/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.core.ticketview.TicketViewCategory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewState;
import com.inet.helpdesk.core.ticketview.ViewUpdateListener;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketViewGroupDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketViewStateDescription;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class ViewUpdateStart
extends TicketListWebSocketEvent<Void> {
    public ViewUpdateStart() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String clientID) {
            }

            public void connectionClosed(String clientID) {
                ViewUpdateStart.this.deregisterFromViewUpdates(clientID);
            }
        });
    }

    public String getEventName() {
        return "ticketlist.viewupdatestart";
    }

    @Override
    protected void handleEvent(String clientID, Void payload) {
        this.registerForViewUpdates(clientID);
    }

    private void registerForViewUpdates(final @Nonnull String clientID) {
        ViewUpdateListener viewUpdatedListener = new ViewUpdateListener(){

            public void viewContentChanged(TicketViewState ticketViewState) {
                ViewUpdateStart.this.sendViewState(clientID, ticketViewState);
            }

            public void viewStructureChanged(Collection<TicketViewState> ticketViewStateList) {
                ViewUpdateStart.this.sendViewStateList(clientID, ticketViewStateList);
            }
        };
        TicketViewManager viewManager = TicketViewManager.getInstance();
        Collection ticketViewStates = viewManager.registerTicketViews(clientID);
        this.sendViewStateList(clientID, ticketViewStates);
        viewManager.addViewUpdateListener(clientID, viewUpdatedListener);
    }

    private void deregisterFromViewUpdates(String clientID) {
        TicketViewManager.getInstance().unregisterTicketViews(clientID);
    }

    private void sendViewState(String clientID, TicketViewState ticketViewState) {
        TicketViewCategory category = ticketViewState.getCategory();
        TicketViewGroupDescription grouping = new TicketViewGroupDescription(category.getKey(), category.getDisplayName(), category.getDescription());
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.ticketviewstate", (Object)new TicketViewStateDescription(ticketViewState.getID(), ticketViewState.getParentID(), grouping, ticketViewState.getDisplayName(), ticketViewState.getDescription(), ticketViewState.getIconKey(), ticketViewState.getTotalTicketCount(), ticketViewState.getUnreadTicketCount(), ticketViewState.getViewExtras())));
    }

    private void sendViewStateList(String clientID, Collection<TicketViewState> ticketViewStates) {
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> {
            ArrayList<TicketViewStateDescription> stateDescriptions = new ArrayList<TicketViewStateDescription>();
            this.addViewStates(stateDescriptions, null, ticketViewStates);
            return new WebSocketEventData("ticketlist.ticketviewstates", stateDescriptions);
        });
    }

    private void addViewStates(ArrayList<TicketViewStateDescription> stateDescriptions, String parentId, Iterable<TicketViewState> ticketViewStates) {
        if (ticketViewStates == null) {
            return;
        }
        for (TicketViewState ticketViewState : ticketViewStates) {
            TicketViewCategory category = ticketViewState.getCategory();
            TicketViewGroupDescription grouping = new TicketViewGroupDescription(category.getKey(), category.getDisplayName(), category.getDescription());
            stateDescriptions.add(new TicketViewStateDescription(ticketViewState.getID(), parentId, grouping, ticketViewState.getDisplayName(), ticketViewState.getDescription(), ticketViewState.getIconKey(), ticketViewState.getTotalTicketCount(), ticketViewState.getUnreadTicketCount(), ticketViewState.getViewExtras()));
            this.addViewStates(stateDescriptions, ticketViewState.getID(), (Iterable<TicketViewState>)ticketViewState);
        }
    }
}

