/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ticketpageextensions.links;

import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageHint;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LinksExtension
implements TicketPageExtension {
    public static final String EXTENSION_KEY = "links";

    @Nonnull
    public String getExtensionName() {
        return EXTENSION_KEY;
    }

    public String getDisplayName() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.links.displayname", new Object[0]);
    }

    public String getDescription() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.links.description", new Object[0]);
    }

    public URL getTemplateURL() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketpage/extensions/linksextension.html");
    }

    public boolean isDefaultVisible() {
        return true;
    }

    public boolean isAvailable(UserAccount userAccount) {
        return HDUsersAndGroups.isSupporter((UserAccount)userAccount);
    }

    public boolean isVisibleForTicket(int ticketID) {
        return !TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketID).hasEnduserAccessToTicket();
    }

    public TicketPageHint getHint(UserAccount userAccount, TicketVO ticket) {
        if (ticket != null) {
            if (ticket.isMasterInBundle()) {
                List ticketsInBundle;
                TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID());
                if (ticketPermissionInfo != null && !ticketPermissionInfo.hasEnduserAccessToTicket() && !(ticketsInBundle = TicketManager.getReader().getTicketsInBundle(ticket.getBundleID(), false)).isEmpty()) {
                    return new TicketPageHint(EXTENSION_KEY, this.getDisplayName(), "links.masterinbundle", TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.links.hint.masterinbundle.title", new Object[0]), TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.links.hint.masterinbundle.message", new Object[0]));
                }
            } else if (ticket.isSlaveInBundle()) {
                int bundleID = ticket.getBundleID();
                boolean canReadTicket = TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(bundleID);
                if (canReadTicket) {
                    return new TicketPageHint(EXTENSION_KEY, this.getDisplayName(), "links.slaveinbundle", TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.links.hint.slaveinbundle.title", new Object[0]), TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.links.hint.slaveinbundle.message", new Object[0]));
                }
            }
            Set linkedTicketIds = ticket.getLinkedTickets();
            for (Integer linkedTicketId : linkedTicketIds) {
                TicketVO linkedTicket;
                if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(linkedTicketId.intValue()) || (linkedTicket = TicketManager.getReader().getTicket(linkedTicketId.intValue())) == null) continue;
                return new TicketPageHint(EXTENSION_KEY, this.getDisplayName(), "links.freelinks", TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.links.hint.freelinks.title", new Object[0]), TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.links.hint.freelinks.message", new Object[0]));
            }
        }
        return null;
    }

    @Nullable
    public String getCountPreview(UserAccount userAccount, TicketVO ticket) {
        int linkCount = 0;
        if (ticket != null) {
            TicketVO linkedTicket;
            if (ticket.isMasterInBundle()) {
                TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID());
                if (ticketPermissionInfo != null && !ticketPermissionInfo.hasEnduserAccessToTicket()) {
                    List ticketsInBundle = TicketManager.getReader().getTicketsInBundle(ticket.getBundleID(), false);
                    linkCount += ticketsInBundle.size();
                }
            } else if (ticket.isSlaveInBundle()) {
                int bundleID = ticket.getBundleID();
                boolean canReadTicket = TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(bundleID);
                if (canReadTicket) {
                    ++linkCount;
                }
            }
            Set linkedTicketIds = ticket.getLinkedTickets();
            if (linkedTicketIds != null) {
                for (Integer linkedTicketId : linkedTicketIds) {
                    Object linkedTicket2;
                    if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(linkedTicketId.intValue()) || (linkedTicket2 = TicketManager.getReader().getTicket(linkedTicketId.intValue())) == null) continue;
                    ++linkCount;
                }
            }
            ItilLinkManager itilManager = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
            Set itilSecondarys = itilManager.getItilSlavesLinkedTo(ticket.getID()).stream().filter(t -> TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(t.intValue())).collect(Collectors.toSet());
            for (Integer slaveId : itilSecondarys.stream().limit(15L).collect(Collectors.toSet())) {
                TicketVO linkedTicket3 = TicketManager.getReader().getTicket(slaveId.intValue());
                if (linkedTicket3 == null) continue;
                ++linkCount;
            }
            Integer itilMaster = itilManager.getItilMasterOf(ticket.getID());
            if (itilMaster != null && TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(itilMaster.intValue()) && (linkedTicket = TicketManager.getReader().getTicket(itilMaster.intValue())) != null) {
                ++linkCount;
            }
        }
        return linkCount == 0 ? null : "" + linkCount;
    }
}

