/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.taskplanner;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.export.TicketExporter;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.error.TaskPlannerCodes;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.job.ResultContainer;
import com.inet.taskplanner.server.api.result.LocalFileResult;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TicketExportJob
extends Job {
    public static final String PROPERTY_TICKETID = "Ticket ID";
    private final String exportType;
    private final List<Integer> ticketIds;
    private boolean hadEntries;

    public TicketExportJob(JobDefinition definition) {
        super(definition.getCondition());
        String ticketIdString = definition.getProperty(PROPERTY_TICKETID);
        this.exportType = definition.getProperty("exportType");
        if (StringFunctions.isEmpty((String)ticketIdString) || ticketIdString.equals("{Ticket ID}")) {
            throw new IllegalArgumentException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.novalidticketid", new Object[0]));
        }
        try {
            this.ticketIds = ticketIdString == null ? new ArrayList() : TicketExportJob.getTicketIds(ticketIdString);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.novalidticketid", new Object[0]));
        }
    }

    @Nonnull
    public static List<Integer> getTicketIds(String ticketIdString) {
        return Arrays.stream(ticketIdString.trim().split("[ ,;]")).filter(s -> !s.isBlank()).map(Integer::parseInt).collect(Collectors.toList());
    }

    protected JobResultContainer run() throws TaskExecutionException {
        ArrayList<Exception> toThrow = new ArrayList<Exception>();
        ArrayList<1> results = new ArrayList<1>();
        for (Integer ticketId : this.ticketIds) {
            try {
                TicketVO ticket = null;
                try {
                    ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
                if (ticket == null) {
                    throw new TaskExecutionException((Throwable)new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.noaccesstoticket", new Object[0])));
                }
                File tempFile = File.createTempFile("TicketExportJob", null);
                try (FileOutputStream outStream = new FileOutputStream(tempFile);){
                    boolean includeSteps = !this.exportType.equals("onlyattachments");
                    boolean includeAttachments = !this.exportType.equals("noattachments");
                    this.hadEntries = new TicketExporter().exportTicketToStream(ticket, outStream, includeSteps, includeAttachments);
                }
                final int tID = ticket.getID();
                if (!this.hadEntries) continue;
                results.add(new LocalFileResult(tempFile, true){

                    @Nonnull
                    public String getFileName() {
                        return tID + ".zip";
                    }
                });
            }
            catch (Throwable e) {
                toThrow.add((Exception)new TaskExecutionException(e));
            }
        }
        if (toThrow.size() > 0) {
            throw TicketExportJob.combinedException(toThrow);
        }
        return new ResultContainer(results);
    }

    static TaskExecutionException combinedException(@Nonnull List<Exception> toThrow) {
        if (toThrow.size() == 0) {
            throw new IllegalArgumentException("need at least one exception");
        }
        StringBuilder combinedMessage = new StringBuilder();
        for (Exception e : toThrow) {
            combinedMessage.append(e.getMessage()).append("\n");
        }
        return new TaskExecutionException((ErrorCode)TaskPlannerCodes.GenericExecutionError, (Throwable)toThrow.get(0), new Object[]{combinedMessage.toString()});
    }

    protected boolean evaluateCondition(ConditionDefinition condition) {
        String template;
        if (condition != null && !StringFunctions.isEmpty((String)(template = (String)condition.getProperties().get("ticketlist.export.job.conditionType")))) {
            switch (template) {
                case "exportHasFiles": {
                    return this.hadEntries;
                }
                case "exportHasNoFiles": {
                    return !this.hadEntries;
                }
            }
        }
        return true;
    }
}

