/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.reporting;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.attachments.server.api.TicketAttachmentProvider;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescriptionList;
import com.inet.helpdesk.plugins.attachments.shared.BooleanMatcher;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ReportingAttachmentFunctions
implements UserDefinedFunction {
    public static Integer getAttachmentCount(int ticketId) throws ServerDataException {
        TicketAttachmentProvider tap = (TicketAttachmentProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAttachmentProvider.class);
        AttachmentDescriptionList attachmentsForTicket = tap.getAllTicketBundleAttachments(ticketId);
        List matched = attachmentsForTicket.getAttachments().getMatched(BooleanMatcher.ONLY_TRUE, BooleanMatcher.ONLY_FALSE);
        return matched.size();
    }

    public static String getAttachmentNameByByte(byte[] fileName) {
        if (fileName == null || fileName.length == 0) {
            return new String();
        }
        return new String(fileName, StandardCharsets.UTF_8);
    }
}

