/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketListLayoutSettingsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TicketListLayoutSettings
extends AbstractTicketListHandler<Void, TicketListLayoutSettingsResponse> {
    public String getMethodName() {
        return "ticketlist.layoutsettings";
    }

    @Override
    protected TicketListLayoutSettingsResponse handleRequest(HttpServletRequest request, HttpServletResponse response, Void input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        TicketListLayoutManager layoutManager = TicketListLayoutManager.getInstance();
        List<TicketListLayoutDescription> userLayouts = layoutManager.getLayouts(currentUser);
        Map<String, TicketListLayoutDescription> userLayoutMap = userLayouts.stream().collect(Collectors.toMap(TicketListLayoutDescription::getLayoutKey, ld -> ld));
        List<TicketListLayoutDescription> defaultLayouts = layoutManager.getLayouts(null);
        Map<String, TicketListLayoutDescription> defaultLayoutMap = defaultLayouts.stream().collect(Collectors.toMap(TicketListLayoutDescription::getLayoutKey, ld -> ld));
        return new TicketListLayoutSettingsResponse(layoutManager.getAllAvailableColumns(false), userLayoutMap, defaultLayoutMap);
    }
}

