/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.UnreadRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;

public class SetTicketUnread
extends AbstractTicketListHandler<UnreadRequestData, Void> {
    public String getMethodName() {
        return "ticketpage.setTicketUnread";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, UnreadRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        List<Integer> ticketIDs = input.getTicketIDs();
        for (Integer ticketId : ticketIDs) {
            boolean canSetUnread;
            TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
            TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID());
            boolean bl = canSetUnread = ticketPermissionInfo.hasSupporterWriteAccessToTicket() || ticketPermissionInfo.hasEnduserAccessToTicket();
            if (input.isUnread() && canSetUnread) {
                try {
                    if (input.getStepId() != null) {
                        TicketManager.getManipulator().markReaStepAsUnread(ticketId.intValue(), input.getStepId().intValue());
                        continue;
                    }
                    TicketManager.getManipulator().changeTicketStatusToUnread(ticketId.intValue());
                    continue;
                }
                catch (AccessDeniedException | IllegalArgumentException | IllegalStateException iae) {
                    TicketListServerPlugin.LOGGER.debug((Object)iae);
                    throw new ClientMessageException(iae.getMessage());
                }
            }
            if (input.isUnread() || !canSetUnread) continue;
            try {
                if (input.getStepId() != null) {
                    TicketManager.getManipulator().markReaStepAsRead(ticketId.intValue(), input.getStepId().intValue());
                    continue;
                }
                TicketManager.getManipulator().changeTicketStatusToRead(ticketId.intValue());
            }
            catch (AccessDeniedException | IllegalArgumentException | IllegalStateException iae) {
                TicketListServerPlugin.LOGGER.debug((Object)iae);
                throw new ClientMessageException(iae.getMessage());
            }
        }
        return null;
    }
}

