/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.SavePropertiesRequest;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public class SaveProperties
extends AbstractTicketListHandler<SavePropertiesRequest, Void> {
    public String getMethodName() {
        return "ticketlist.saveproperties";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, SavePropertiesRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        Map<String, String> values = input.getValues();
        List<Integer> ticketIDs = input.getTicketIds();
        MutableTicketData mutableTicketData = this.createMutableDataFromValues(values);
        for (Integer ticketId : ticketIDs) {
            try {
                TicketManager.getManipulator().updateTicketData(ticketId.intValue(), mutableTicketData);
            }
            catch (IllegalArgumentException | IllegalStateException iae) {
                TicketListServerPlugin.LOGGER.debug((Object)iae);
                throw new ClientMessageException(iae.getMessage());
            }
            if (!input.isLeaveTicketAfterSuccess()) continue;
            TicketAccessInformationsProvider ticketAccessInformationsProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
            ticketAccessInformationsProvider.leaveTickets(input.getClientID(), new int[]{ticketId});
        }
        return null;
    }

    private MutableTicketData createMutableDataFromValues(Map<String, String> values) {
        MutableTicketData ticketData = new MutableTicketData();
        List fieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        for (TicketFieldDefinition def : fieldDefinitions) {
            FieldEditDefinition editDefinition = def.getEditDefinition();
            if (editDefinition == null || !values.containsKey(editDefinition.getFieldKey())) continue;
            editDefinition.updateTicketData(ticketData, values);
        }
        return ticketData;
    }
}

