/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.InitialDataResponse;
import com.inet.helpdesk.plugins.ticketlist.server.data.Sorting;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InitialData
extends AbstractTicketListHandler<Void, InitialDataResponse> {
    private static final ConfigValue<Integer> askNewTicketDestination = new ConfigValue(HDConfigKeys.ASK_NEW_TICKET_DESTINATION);
    private static final ConfigValue<Integer> DELAY_READ_SECONDS = new ConfigValue(HDConfigKeys.SET_READ_DELAY_SECONDS);

    public String getMethodName() {
        return "ticketlist.initialdata";
    }

    @Override
    protected InitialDataResponse handleRequest(HttpServletRequest request, HttpServletResponse response, Void input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        List fieldIdsVisibleForEnduser;
        TicketListLayoutDescription ticketListLayout = TicketListLayoutManager.getInstance().getCurrentLayout(currentUser.getID());
        TicketPageLayoutDescription ticketPageLayout = TicketPageLayoutManager.getInstance().getCurrentLayout(currentUser.getID());
        String sortingSerialized = (String)currentUser.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_SORTING);
        String sortingSerializedDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField(TicketListServerPlugin.USERFIELD_TICKETLIST_SORTING);
        Sorting sorting = new Sorting(Tickets.ATTRIBUTE_LAST_CHANGED.getKey(), false);
        if (!StringFunctions.isEmpty((String)sortingSerializedDefault)) {
            sorting.merge((Sorting)new Json().fromJson(sortingSerializedDefault, Sorting.class));
        }
        if (!StringFunctions.isEmpty((String)sortingSerialized)) {
            sorting.merge((Sorting)new Json().fromJson(sortingSerialized, Sorting.class));
        }
        String viewSpecificSortingSerialized = (String)currentUser.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_VIEWSPECIFIC_SORTING);
        String viewSpecificSortingSerializedDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField(TicketListServerPlugin.USERFIELD_TICKETLIST_VIEWSPECIFIC_SORTING);
        HashMap<String, Sorting> viewSpecificSorting = new HashMap<String, Sorting>();
        if (!StringFunctions.isEmpty((String)viewSpecificSortingSerializedDefault)) {
            viewSpecificSorting.putAll((Map)new Json().fromJson(viewSpecificSortingSerializedDefault, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, Sorting.class})));
        }
        if (!StringFunctions.isEmpty((String)viewSpecificSortingSerialized)) {
            viewSpecificSorting.putAll((Map)new Json().fromJson(viewSpecificSortingSerialized, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, Sorting.class})));
        }
        if ((fieldIdsVisibleForEnduser = Tickets.getFieldIdsVisibleForUser()) != null) {
            if (!fieldIdsVisibleForEnduser.contains(sorting.getColumnKey())) {
                sorting = new Sorting(Tickets.ATTRIBUTE_LAST_CHANGED.getKey(), false);
            }
            if (!fieldIdsVisibleForEnduser.contains(sorting.getColumnKey())) {
                sorting = new Sorting("ticketid", false);
            }
        }
        String lastViewID = (String)currentUser.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_LASTVIEW);
        boolean isSupporter = HDUsersAndGroups.isSupporter((UserAccount)currentUser);
        boolean isTicketEditor = HDUsersAndGroups.isResourceMember((UserAccount)currentUser) || SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE});
        boolean canCreateNewTicket = TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(4);
        InitialDataResponse initialDataResponse = new InitialDataResponse();
        initialDataResponse.setTicketListLayout(ticketListLayout);
        initialDataResponse.setTicketPageLayout(ticketPageLayout);
        initialDataResponse.setSorting(sorting);
        initialDataResponse.setViewSpecificSorting(viewSpecificSorting);
        initialDataResponse.setLastViewID(lastViewID);
        initialDataResponse.setSupporter(isSupporter);
        initialDataResponse.setTicketEditor(isTicketEditor);
        initialDataResponse.setHelpdeskUserID(HDUsersAndGroups.getUserID((GUID)currentUser.getID()));
        initialDataResponse.setCanCreateNewTicket(canCreateNewTicket);
        initialDataResponse.setAskNewTicketDestination((Integer)askNewTicketDestination.get());
        initialDataResponse.setHasAccessToUsersAndGroups(ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER));
        initialDataResponse.setReadDuration((Integer)DELAY_READ_SECONDS.get());
        return initialDataResponse;
    }
}

