/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetStepTextsCombinedRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetStepTextsCombinedResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class GetStepTextsCombined
extends AbstractTicketListHandler<GetStepTextsCombinedRequest, GetStepTextsCombinedResponse> {
    public String getMethodName() {
        return "ticketlist.getsteptextscombined";
    }

    @Override
    protected GetStepTextsCombinedResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetStepTextsCombinedRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        Font defaultFont;
        StringBuilder text = new StringBuilder();
        int ticketId = input.getTicketId();
        boolean quotation = input.isQuotation();
        List<Integer> stepIds = input.getStepIds();
        if (stepIds != null) {
            HashSet<Integer> availableStepsIds = new HashSet<Integer>();
            TicketReader ticketReader = TicketManager.getReader();
            List reaStepVOs = ticketReader.getReaStepsForTicket(ticketId, BundleStepsFilter.WITH_BUNDLE_STEPS);
            for (ReaStepVO step : reaStepVOs) {
                availableStepsIds.add(step.getID());
            }
            stepIds.removeIf(id -> !availableStepsIds.contains(id));
            stepIds.sort(Comparator.reverseOrder());
            for (Integer stepId : stepIds) {
                ReaStepTextVO reaStepText;
                ReaStepVO reaStep = ticketReader.getReaStep(stepId.intValue());
                if (reaStep == null || (reaStepText = ticketReader.getReaStepText(stepId.intValue())) == null) continue;
                String textContent = reaStepText.getText();
                if (textContent == null) {
                    textContent = "";
                }
                if (!reaStepText.hasHtmlContent()) {
                    textContent = HtmlConverter.text2html((String)textContent, (Font)TicketTextFunctions.getDefaultFont());
                    textContent = textContent.replace("<head>", "<head><style>p{margin: 0px;}</style>");
                }
                textContent = TicketTextFunctions.getInlinedHtml((String)textContent, (boolean)false);
                textContent = textContent.trim();
                if (!text.isEmpty()) {
                    text.append("<br>");
                }
                text.append(textContent);
            }
        }
        if (quotation) {
            text.insert(0, "<div style=\"border-top-style:none;border-right-style:none;border-bottom-style:none;border-left-style:solid;border-left-color:blue;border-left-width:1.5pt;padding-top:0cm;padding-right:0cm;padding-bottom:0cm;padding-left:4pt;\">");
            text.append("</div>");
        }
        if (input.isWrapWithDefaultFont() && (defaultFont = TicketTextFunctions.getDefaultFont()) != null) {
            text.insert(0, "<div style=\"font-family:'" + defaultFont.getFamily() + "'; font-size: " + defaultFont.getSize() + "pt;\">");
            text.append("</div>");
        }
        return new GetStepTextsCombinedResponse(text.toString(), HtmlConverter.html2text((String)text.toString()));
    }
}

