/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketlist.api.data.Sender;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetSenderRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetSenderResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.shared.TicketEmailSenderInformationCreator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GetSender
extends AbstractTicketListHandler<GetSenderRequestData, GetSenderResponseData> {
    public String getMethodName() {
        return "applyaction_getsender";
    }

    @Override
    protected GetSenderResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, GetSenderRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        boolean filter;
        int currentSize = input.getCurrentSize();
        ArrayList<Sender> senderEntries = new ArrayList<Sender>();
        boolean bl = filter = !StringFunctions.isEmpty((String)input.getSearchTerm());
        if (filter && !StringFunctions.isEmpty((String)input.getCustomvalue())) {
            String displayName = EmailAddressHelper.get().extractAlias(input.getCustomvalue());
            String email = EmailAddressHelper.get().extractEmailAddress(input.getCustomvalue());
            if (StringFunctions.isEmpty((String)email)) {
                email = input.getCustomvalue();
            }
            if (!StringFunctions.isEmpty((String)displayName) && displayName.equals(email) || displayName == null) {
                displayName = "";
            }
            senderEntries.add(new Sender(displayName, email, "", null));
        }
        TicketVO ticket = null;
        if (input.getTicketID() != null) {
            ticket = TicketManager.getReader().getTicket(input.getTicketID().intValue());
        }
        senderEntries.addAll(this.getSenderEntries(currentUser, ticket, input.getSearchTerm()));
        int totalCount = senderEntries.size();
        int end = currentSize + input.getTargetSize();
        end = Math.min(end, totalCount);
        return new GetSenderResponseData(senderEntries.subList(currentSize, end), totalCount);
    }

    public ArrayList<Sender> getSenderEntries(UserAccount currentUser, TicketVO ticket, String searchTerm) {
        List<TicketEmailSenderInformation> senderInformation = this.getSenderInformation(currentUser, ticket);
        return senderInformation.stream().filter(i -> searchTerm == null || searchTerm.trim().isEmpty() || GetSender.containsIgnoreCase(i.getDisplayName(), searchTerm) || GetSender.containsIgnoreCase(i.getEmail(), searchTerm)).map(GetSender::generateSenderFromSenderInformation).collect(Collectors.toCollection(ArrayList::new));
    }

    protected List<TicketEmailSenderInformation> getSenderInformation(UserAccount currentUser, TicketVO ticket) {
        return TicketEmailSenderInformationCreator.getSenderInformation((UserAccount)currentUser, (GUID)(ticket == null ? null : ticket.getResourceID()), (Integer)(ticket == null ? null : ticket.getCategoryID()), (String)(ticket == null ? null : ticket.getEmailEingang()));
    }

    private static Sender generateSenderFromSenderInformation(TicketEmailSenderInformation i) {
        String iconValue = "211";
        Sender.IconType iconType = Sender.IconType.statusid;
        String idObject = i.getIdObject();
        switch (i.getSenderType()) {
            case owner: {
                iconValue = idObject;
                iconType = Sender.IconType.ownerid;
                break;
            }
            case resource: {
                Integer resID = null;
                try {
                    UserGroupInfo group;
                    resID = Integer.valueOf(idObject);
                    GUID resourceGroupUUID = HDUsersAndGroups.getResourceGroupUUID((int)resID);
                    if (resourceGroupUUID == null || (group = UserGroupManager.getInstance().getGroup(resourceGroupUUID)) == null) break;
                    iconValue = HDUsersAndGroups.getResourceIconKey((UserGroupInfo)group);
                    iconType = Sender.IconType.resourceid;
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
        }
        return new Sender(i.getDisplayName(), i.getEmail(), iconValue, iconType);
    }

    private static boolean containsIgnoreCase(String sourceText, String searchTerm) {
        return StringFunctions.likeCaseSensitive((String)sourceText.toLowerCase(), (String)("*" + searchTerm.toLowerCase().replace(" ", "*") + "*"));
    }
}

