/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetAvailableActionsForSelectedTicketsRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetAvailableActionsForSelectedTicketsResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class GetAvailableActionsForSelectedTickets
extends AbstractTicketListHandler<GetAvailableActionsForSelectedTicketsRequestData, GetAvailableActionsForSelectedTicketsResponseData> {
    @Override
    protected GetAvailableActionsForSelectedTicketsResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, GetAvailableActionsForSelectedTicketsRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        ActionCheckError checkAktionBuendeln;
        List<Integer> slaveticketids;
        ArrayList<Integer> allTicketIds = new ArrayList<Integer>();
        Integer masterticketid = input.getMasterticketid();
        if (masterticketid != null) {
            allTicketIds.add(masterticketid);
        }
        if ((slaveticketids = input.getSlaveticketids()) != null) {
            allTicketIds.addAll(slaveticketids);
        }
        HashSet<ActionVO> availableActions = null;
        TicketReader ticketReader = TicketManager.getReader();
        for (Integer ticketID : allTicketIds) {
            List allPossibleActions;
            TicketVO ticket = ticketReader.getTicket(ticketID.intValue());
            if (availableActions == null) {
                availableActions = new HashSet();
                allPossibleActions = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticket.getID());
                if (allPossibleActions == null) continue;
                availableActions.addAll(allPossibleActions);
                continue;
            }
            allPossibleActions = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticket.getID());
            availableActions.removeIf(a -> !allPossibleActions.contains(a));
        }
        if (availableActions == null) {
            availableActions = new HashSet<ActionVO>();
        }
        ActionVO actionBundle = (ActionVO)ActionManager.getInstance().get(-1);
        availableActions.remove(actionBundle);
        if (masterticketid != null && slaveticketids != null && !slaveticketids.isEmpty() && (checkAktionBuendeln = TicketManager.getTicketActionChecker().checkAktionBuendeln(masterticketid.intValue(), slaveticketids)) == null) {
            availableActions.add(actionBundle);
        }
        return new GetAvailableActionsForSelectedTicketsResponseData(availableActions.stream().map(ActionVO::getUniqueID).collect(Collectors.toSet()), input.getCounter());
    }

    public String getMethodName() {
        return "ticketlist.getavailableactionsforselectedtickets";
    }
}

