/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.ticketlist.server.data.EnableExtensionRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageExtensionDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutManager;
import com.inet.http.ClientMessageException;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;

public class EnableExtension
extends AbstractTicketListHandler<EnableExtensionRequest, Void> {
    public String getMethodName() {
        return "ticketlist.extensions.enable";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, EnableExtensionRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        TicketPageLayoutManager layoutManager = TicketPageLayoutManager.getInstance();
        TicketPageLayoutDescription currentLayout = layoutManager.getCurrentLayout(currentUser.getID());
        List<TicketPageLayoutDescription> layouts = layoutManager.getLayouts(currentUser);
        for (TicketPageLayoutDescription layout : layouts) {
            boolean existing;
            if (!layout.getLayoutKey().equals(currentLayout.getLayoutKey()) || (existing = layout.getExtensions().stream().filter(e -> e.getId().equals(input.getExtensionId())).findAny().isPresent())) continue;
            layout.getExtensions().add(new TicketPageExtensionDescription(input.getExtensionId(), "", ""));
            layout.getHiddenExtensions().remove(input.getExtensionId());
        }
        layoutManager.saveLayoutsForUser(currentUser, currentLayout.getLayoutKey(), layouts);
        WebSocketEventHandler.getInstance().sendEvent(currentUser.getID(), () -> new WebSocketEventData("ticketlist.ticketpagelayoutchanged", (Object)layoutManager.getCurrentLayout(currentUser.getID())));
        WebSocketEventHandler.getInstance().sendEvent(currentUser.getID(), () -> new WebSocketEventData("ticketlist.ticketpageselectextension", (Object)input.getExtensionId()));
        return null;
    }
}

