/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.config.autotext.handler.AutoTextAttachmentHelper;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.AutoTextDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.plugins.ticketlist.api.editing.AdditionalCloseActions;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.EditPropertiesRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.EditPropertiesResponse;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketPageUpdateStart;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EditProperties
extends AbstractTicketListHandler<EditPropertiesRequest, EditPropertiesResponse> {
    public String getMethodName() {
        return "ticketlist.editproperties";
    }

    @Override
    protected EditPropertiesResponse handleRequest(HttpServletRequest request, HttpServletResponse response, EditPropertiesRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        TicketAccessInfo ticketAccessInfo;
        GUID ownerId = input.getOwnerId();
        TicketAccessInformationsProvider ticketAccessInformationsProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
        List<Integer> ticketIds = input.getTicketIds();
        boolean isInTicketDetailsPage = false;
        if (ticketIds != null && ticketIds.size() == 1 && (ticketAccessInfo = ticketAccessInformationsProvider.getTicketAccessInfo(input.getTicketIds().get(0).intValue())) != null) {
            boolean present = ticketAccessInfo.getReadSessions().stream().filter(s -> input.getClientID().equals(s.getClientID())).findAny().isPresent();
            if (!present) {
                TicketAccessInfo.TicketAccessor writeSession = ticketAccessInfo.getWriteSession();
                present = writeSession != null && input.getClientID().equals(writeSession.getClientID());
            }
            isInTicketDetailsPage = present;
        }
        ArrayList<TicketVO> tickets = null;
        if (ticketIds != null) {
            TicketReader ticketReader = TicketManager.getReader();
            for (Integer n : ticketIds) {
                TicketVO ticket = ticketReader.getTicket(n.intValue());
                if (ticket == null) continue;
                if (tickets == null) {
                    tickets = new ArrayList<TicketVO>();
                }
                tickets.add(ticket);
                TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(n.intValue());
                boolean canManageTicket = ticketPermissionInfo.hasSupporterWriteAccessToTicket();
                if (canManageTicket && Status.isClosedStatus((int)ticket.getStatusID())) {
                    boolean bl = canManageTicket = (Integer)TicketPageUpdateStart.CONTENT_CHANGEABLE.get() == 2;
                }
                if (canManageTicket) continue;
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.writepermission.failed", new Object[]{String.valueOf(n)}));
            }
            boolean writeLock = false;
            for (Integer ticketId : ticketIds) {
                TicketVO ticket = ticketReader.getTicket(ticketId.intValue());
                if (ticket != null) {
                    writeLock = ticketAccessInformationsProvider.accessTicketWrite(input.getClientID(), ticketId.intValue());
                }
                if (writeLock) continue;
                ticketAccessInformationsProvider.leaveAllTickets(input.getClientID());
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.lock.failed", new Object[]{String.valueOf(ticketId)}));
            }
        }
        ArrayList<FieldEditDescription> fields = new ArrayList<FieldEditDescription>();
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> editHints = new HashMap<String, String>();
        for (TicketFieldDefinition definition : fieldDefs) {
            FieldEditDefinition editDefinition = definition.getEditDefinition();
            if (editDefinition == null) continue;
            String editHint = editDefinition.getEditHint(tickets);
            if (!StringFunctions.isEmpty((String)editHint)) {
                editHints.put(editDefinition.getFieldKey(), editHint);
            }
            if (!editDefinition.isAvailable(tickets)) continue;
            if (ticketIds == null) {
                editDefinition.updateCurrentValue(null, ownerId, hashMap);
            } else if (ticketIds.size() == 1) {
                editDefinition.updateCurrentValue(TicketManager.getReader().getTicket(ticketIds.get(0).intValue()), ownerId, hashMap);
            } else if (ticketIds.size() > 1) {
                boolean multiValues = false;
                String oldDisplayValue = null;
                for (int i = 0; i < ticketIds.size(); ++i) {
                    String displayValue = definition.getDisplayValue(TicketManager.getReader().getTicket(ticketIds.get(i).intValue()));
                    if (i > 0 && !Objects.equals(oldDisplayValue, displayValue)) {
                        multiValues = true;
                        break;
                    }
                    oldDisplayValue = displayValue;
                }
                if (multiValues) {
                    editDefinition.updateCurrentValue(null, ownerId, hashMap);
                } else {
                    editDefinition.updateCurrentValue(TicketManager.getReader().getTicket(ticketIds.get(0).intValue()), ownerId, hashMap);
                }
            }
            FieldEditDescription description = new FieldEditDescription(editDefinition.getFieldKey(), editDefinition.getDisplayType(), editDefinition.getDisplayName(), definition.getDescription(), definition.getProperties());
            fields.add(description);
        }
        List<AutoTextDescription> autoTexts = null;
        List<AdditionalCloseActions> additionalCloseActions = null;
        List<SavedAttachmentData> initialAttachments = null;
        HashMap<Integer, List<SavedAttachmentData>> autoTextAttachments = new HashMap<Integer, List<SavedAttachmentData>>();
        if (ticketIds == null) {
            ActionVO autorisierenAction;
            fields.add(new FieldEditDescription(TicketFieldRendererId.htmleditor.name(), "htmltext", null, null, Collections.emptyMap()));
            hashMap.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf((Boolean)ApplyActionRendererProvider.DEFAULT_TICKET_PLAINTEXT_REASTEP.get() == false));
            hashMap.put(TicketFieldRendererId.htmleditor.name(), "");
            Font defaultFont = TicketTextFunctions.getDefaultFont();
            if (defaultFont != null) {
                hashMap.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
                hashMap.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
            }
            boolean supporter = HDUsersAndGroups.isSupporter((UserAccount)currentUser);
            AutoTextManager autoTextManager = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
            List autoTextVOs = autoTextManager.getAutoTexts(null, null, Integer.valueOf(4));
            if (autoTextVOs != null) {
                if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                    autoTextVOs.forEach(at -> {
                        List attachments = AutoTextAttachmentHelper.getAutoTextAttachments((int)at.getId());
                        autoTextAttachments.put(at.getId(), attachments);
                    });
                }
                if (!supporter) {
                    ArrayList autoTextsForTicketCreation = new ArrayList();
                    autoTextVOs.forEach(at -> {
                        if (at.isTicketCreation()) {
                            autoTextsForTicketCreation.add(at);
                        }
                    });
                    int userID = HDUsersAndGroups.getUserID((GUID)UserManager.getInstance().getCurrentUserAccountID());
                    List ownAutoTextForTicketCreation = autoTextsForTicketCreation.stream().filter(at -> at.getUserId() != null && at.getUserId() == userID).collect(Collectors.toList());
                    if (ownAutoTextForTicketCreation.isEmpty()) {
                        ownAutoTextForTicketCreation = autoTextsForTicketCreation;
                    }
                    if (ownAutoTextForTicketCreation.size() == 1) {
                        AutoTextVO initialTextForTicketCreation = (AutoTextVO)ownAutoTextForTicketCreation.get(0);
                        hashMap.put(TicketFieldRendererId.htmleditor.name(), TicketFunctions.getAutoTextHtml(initialTextForTicketCreation.getContentText()));
                        hashMap.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(true));
                        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                            initialAttachments = autoTextAttachments.get(initialTextForTicketCreation.getId());
                        }
                    } else {
                        autoTexts = TicketFunctions.convertAutoTexts(autoTextVOs);
                    }
                } else {
                    autoTexts = TicketFunctions.convertAutoTexts(autoTextVOs);
                }
            }
            if (ServerPluginManager.getInstance().isPluginLoaded(TicketFieldRendererId.attachments.name())) {
                fields.add(new FieldEditDescription(TicketFieldRendererId.attachments.name(), "attachmentsadd", TicketListServerPlugin.CLIENT_MSG.getMsg("ticketlist.applyaction.attachmentsadd", new Object[0]), null, Collections.emptyMap()));
                hashMap.put(TicketFieldRendererId.attachments.name(), String.valueOf(0));
            }
            if (supporter && (autorisierenAction = (ActionVO)ActionManager.getInstance().get(5)) != null) {
                additionalCloseActions = ApplyActionRendererProvider.getInstance().getAdditionalCloseActions(autorisierenAction, null, isInTicketDetailsPage);
            }
        }
        return new EditPropertiesResponse(fields, hashMap, editHints, autoTexts, autoTextAttachments, additionalCloseActions, initialAttachments);
    }
}

