/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.EditAnnotationRequest;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class EditAnnotation
extends AbstractTicketListHandler<EditAnnotationRequest, Void> {
    public String getMethodName() {
        return "ticketlist.extension.annotation.editannotation";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, EditAnnotationRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        boolean supporter = HDUsersAndGroups.isSupporter((UserAccount)currentUser);
        if (!supporter) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.permissionrequired.supporter", new Object[0]));
        }
        int ticketId = input.getTicketId();
        TicketAccessInformationsProvider ticketAccessProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
        boolean writeLock = ticketAccessProvider.accessTicketWrite(input.getClientID(), ticketId);
        if (!writeLock) {
            ticketAccessProvider.leaveAllTickets(input.getClientID());
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.lock.failed", new Object[]{String.valueOf(ticketId)}));
        }
        return null;
    }
}

