/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.server.data.CreateNewTicketRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.data.CreateNewTicketResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateNewTicket
extends AbstractTicketListHandler<CreateNewTicketRequestData, CreateNewTicketResponseData> {
    public String getMethodName() {
        return "ticketpage.createnewticket";
    }

    @Override
    protected CreateNewTicketResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, CreateNewTicketRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        Map<String, String> values = input.getValues();
        boolean htmlContent = Boolean.valueOf(values.remove(TicketFieldRendererId.htmlcontent.name()));
        String stepContent = values.remove(TicketFieldRendererId.htmleditor.name());
        stepContent = htmlContent ? TicketTextFunctions.prepareHtmlTextForSaving((String)TicketTextFunctions.correctAttachmentPathesForServer((String)stepContent)) : TicketTextFunctions.convertToPlainText((String)stepContent);
        ReaStepTextVO ticketText = ReaStepTextVO.of((String)stepContent, (boolean)htmlContent);
        String subject = values.get(Tickets.FIELD_SUBJECT.getKey());
        if (StringFunctions.isEmpty((String)subject) && ticketText.isEmpty()) {
            throw new ClientMessageException(Tickets.MSG.getMsg("error.actionRequiresText", new Object[0]));
        }
        ExtensionArguments extensionArgs = ExtensionArguments.create();
        if (!HDUsersAndGroups.isSupporter((UserAccount)currentUser)) {
            extensionArgs.put(ExtensionArguments.EXTARG_NEW_USER_TICKET_JS_TRIGGER, (Object)Boolean.TRUE);
        }
        UserAccount targetUser = UserManager.getInstance().getUserAccount(input.getOwnerId());
        MutableTicketData mutableTicketData = this.createMutableDataForNewTicket(targetUser, values);
        List<String> additionalCloseActionKeys = input.getAdditionalCloseActionKeys();
        boolean dontopen = false;
        if (HDUsersAndGroups.isSupporter((UserAccount)currentUser)) {
            boolean canAuthorize = TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(5);
            if (canAuthorize) {
                if (additionalCloseActionKeys.contains("authorize")) {
                    extensionArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.ALWAYS);
                } else if (additionalCloseActionKeys.contains("authorizeAndSuppressAutoMail")) {
                    extensionArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.ALWAYS);
                } else if (additionalCloseActionKeys.contains("authorizeAndDontOpen")) {
                    extensionArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.ALWAYS);
                    dontopen = true;
                } else if (HDUsersAndGroups.isDispatcher((UserAccount)currentUser)) {
                    extensionArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.NOT);
                } else {
                    GUID ressourceId = (GUID)mutableTicketData.get((TicketField)Tickets.FIELD_RESOURCE_GUID);
                    if (ressourceId != null) {
                        extensionArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.NOT);
                    } else {
                        extensionArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.IF_RESOURCE_AVAILABLE);
                    }
                }
            } else {
                extensionArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.NOT);
            }
            if (additionalCloseActionKeys.contains("authorizeAndSuppressAutoMail")) {
                extensionArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, (Object)TicketDataConnector.MailNotification.NO_MAILS_TO_ENDUSER);
            }
            if (additionalCloseActionKeys.contains("onlyCreateInquiryAndDontOpen")) {
                dontopen = true;
            }
        }
        this.addAttachmentsToExtensionArgs(request, input, extensionArgs);
        try {
            TicketVO createTicket = TicketManager.getManipulator().createTicket(ticketText, mutableTicketData, null, extensionArgs);
            boolean canread = dontopen ? false : TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(createTicket.getID());
            return new CreateNewTicketResponseData(createTicket.getID(), canread);
        }
        catch (IllegalArgumentException | IllegalStateException iae) {
            TicketListServerPlugin.LOGGER.debug((Object)iae);
            throw new ClientMessageException(iae.getMessage());
        }
    }

    private void addAttachmentsToExtensionArgs(HttpServletRequest request, CreateNewTicketRequestData input, ExtensionArguments extensionArgs) throws ClientMessageException {
        try {
            List<AttachmentDescription> attachments = input.getAttachments();
            if (attachments != null && !attachments.isEmpty()) {
                ArrayList<LargeContent> attachmentsWithData = new ArrayList<LargeContent>();
                for (int i = 0; i < attachments.size(); ++i) {
                    AttachmentDescription attachment = attachments.get(i);
                    final Part part = request.getPart("attachment" + i);
                    if (attachment == null || part == null) continue;
                    LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                        public InputStream getStream() {
                            try {
                                return part.getInputStream();
                            }
                            catch (Exception e) {
                                HDLogger.error((Object)e);
                                return null;
                            }
                        }

                        public long getSize() {
                            return part.getSize();
                        }
                    });
                    lc.setContentType(AttachmentType.valueOf((String)attachment.getAttachmentType().name()));
                    lc.setLastModified(attachment.getLastModified());
                    lc.setName(attachment.getName());
                    attachmentsWithData.add(lc);
                }
                extensionArgs.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, (Object)new AddAttachmentsExtensionData(attachmentsWithData));
            }
        }
        catch (Throwable t) {
            TicketListServerPlugin.LOGGER.error(t);
            throw new ClientMessageException(t.getMessage());
        }
    }

    private MutableTicketData createMutableDataForNewTicket(UserAccount targetUser, Map<String, String> values) throws ServerDataException {
        MutableTicketData ticketData = new MutableTicketData();
        List fieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            FieldEditDefinition editDefinition;
            TicketFieldDefinition ticketFieldDefinition = fieldDefinitions.stream().filter(def -> def.getKey().equals(entry.getKey())).findAny().orElse(null);
            if (ticketFieldDefinition == null || (editDefinition = ticketFieldDefinition.getEditDefinition()) == null) continue;
            editDefinition.updateTicketData(ticketData, values);
        }
        ticketData.put((TicketField)Tickets.FIELD_OWNER_GUID, (Object)targetUser.getID());
        return ticketData;
    }
}

