/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.BundleSelectedTicketsRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.data.BundleSelectedTicketsResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

public class BundleSelectedTickets
extends AbstractTicketListHandler<BundleSelectedTicketsRequestData, BundleSelectedTicketsResponseData> {
    @Override
    protected BundleSelectedTicketsResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, BundleSelectedTicketsRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        List<Integer> slaveticketids = input.getSlaveticketids();
        if (input.isCheckpermissionsonly()) {
            ActionCheckError checkAktionBuendeln = TicketManager.getTicketActionChecker().checkAktionBuendeln(input.getMasterticketid().intValue(), slaveticketids);
            if (checkAktionBuendeln != null) {
                String errorMessage = checkAktionBuendeln.getErrorMessage();
                return new BundleSelectedTicketsResponseData(false, errorMessage);
            }
            slaveticketids.add(input.getMasterticketid());
            ArrayList<Integer> lockedTickets = new ArrayList<Integer>();
            for (Integer value : slaveticketids) {
                TicketAccessInfo ticketAccessInfo = ((TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class)).getTicketAccessInfo(value.intValue());
                if (ticketAccessInfo == null || ticketAccessInfo.getWriteSession() == null) continue;
                lockedTickets.add(value);
            }
            if (!lockedTickets.isEmpty()) {
                return new BundleSelectedTicketsResponseData(false, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.bundleticket.ticketlock", new Object[]{lockedTickets.toString().substring(1, lockedTickets.toString().length() - 1), lockedTickets.size()}));
            }
            return new BundleSelectedTicketsResponseData(true, null);
        }
        try {
            TicketManager.getManipulator().bundleTickets(input.getMasterticketid().intValue(), slaveticketids);
        }
        catch (IllegalArgumentException | IllegalStateException iae) {
            TicketListServerPlugin.LOGGER.debug((Object)iae);
            throw new ClientMessageException(iae.getMessage());
        }
        return null;
    }

    public String getMethodName() {
        return "ticketlist.bundleselectedtickets";
    }
}

