/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public abstract class AbstractTicketListHandler<InputType, OutputType>
extends ServiceMethod<InputType, OutputType> {
    public short getMethodType() {
        return 1;
    }

    public OutputType invoke(HttpServletRequest request, HttpServletResponse response, InputType input) throws IOException {
        try {
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            if (currentUserAccount == null) {
                ClientMessageException exception = new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.userloginrequired", new Object[0]));
                TicketListServerPlugin.LOGGER.debug((Object)exception);
                throw exception;
            }
            return this.handleRequest(request, response, input, currentUserAccount);
        }
        catch (ServerDataException e) {
            TicketListServerPlugin.LOGGER.error((Throwable)e);
            Throwable cause = e;
            if (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof ClientMessageException) {
                throw (ClientMessageException)cause;
            }
            throw new ClientMessageException(cause.getMessage());
        }
    }

    protected abstract OutputType handleRequest(HttpServletRequest var1, HttpServletResponse var2, InputType var3, UserAccount var4) throws ClientMessageException, ServerDataException;
}

