/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.NewTicketDialogSettings;
import com.inet.helpdesk.plugins.ticketlist.server.data.NewTicketSettingsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketFieldVisibility;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class NewTicketSettings
extends TicketListWebSocketEvent<Void> {
    public String getEventName() {
        return "ticketlist.newticketsettings";
    }

    @Override
    protected void handleEvent(String clientID, Void payload) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        String newTicketSettingValue = currentUserAccount == null ? null : (String)currentUserAccount.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_NEWTICKETSETTING);
        String newTicketSettingValueDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField(TicketListServerPlugin.USERFIELD_TICKETLIST_NEWTICKETSETTING);
        boolean isSupporter = currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
        boolean isDispatcher = currentUserAccount != null && HDUsersAndGroups.isDispatcher((UserAccount)currentUserAccount);
        NewTicketDialogSettings newTicketSetting = new NewTicketDialogSettings(isSupporter);
        if (!StringFunctions.isEmpty((String)newTicketSettingValueDefault)) {
            newTicketSetting.merge((NewTicketDialogSettings)new Json().fromJson(newTicketSettingValueDefault, NewTicketDialogSettings.class));
        }
        if (!StringFunctions.isEmpty((String)newTicketSettingValue)) {
            newTicketSetting.merge((NewTicketDialogSettings)new Json().fromJson(newTicketSettingValue, NewTicketDialogSettings.class));
        }
        MandatoryFieldsManager mandatoryFieldsManager = (MandatoryFieldsManager)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
        List mandatoryFieldSettings = mandatoryFieldsManager.getMandatoryFieldSettings();
        HashSet requiredFields = new HashSet();
        mandatoryFieldSettings.forEach(mf -> {
            if (!isSupporter) {
                if (mf.getUserMandatorySetting() == MandatoryFieldVO.MandatoryType.REQUIRED) {
                    requiredFields.add(mf.getTicketField().getKey());
                }
            } else if (isDispatcher) {
                if (mf.isRequiredForDispatcher()) {
                    requiredFields.add(mf.getTicketField().getKey());
                }
            } else if (isSupporter && mf.isRequiredForSupporter()) {
                requiredFields.add(mf.getTicketField().getKey());
            }
        });
        Comparator<TicketListColumnDescription> compareByGroupAndDisplayName = Comparator.comparing(TicketListColumnDescription::getGroupingKey).thenComparing(TicketListColumnDescription::getDisplayName, String.CASE_INSENSITIVE_ORDER);
        List<TicketListColumnDescription> allAvailableColumns = TicketListLayoutManager.getInstance().getAllAvailableColumns(true);
        ArrayList<TicketFieldVisibility> hiddenTicketFields = newTicketSetting.getHiddenTicketFields();
        ArrayList<TicketFieldVisibility> newHiddenTicketFields = new ArrayList<TicketFieldVisibility>();
        List columnKeysTicket = allAvailableColumns.stream().filter(c -> c.getGroupingKey().equals(TicketFieldDefinition.FIELD_GROUPING.TICKET.name())).sorted(compareByGroupAndDisplayName).map(TicketListColumnDescription::getKey).collect(Collectors.toList());
        columnKeysTicket.remove(Tickets.FIELD_SUBJECT.getKey());
        columnKeysTicket.remove(Tickets.ATTRIBUTE_ATTACHMENTS.getKey());
        for (TicketFieldVisibility hiddenField : hiddenTicketFields) {
            if (hiddenField == null) continue;
            if (requiredFields.contains(hiddenField.getTicketFieldKey())) {
                hiddenField.setHidden(false);
                hiddenField.setMandatory(true);
            }
            if (!columnKeysTicket.remove(hiddenField.getTicketFieldKey())) continue;
            newHiddenTicketFields.add(hiddenField);
        }
        for (String columnKey : columnKeysTicket) {
            newHiddenTicketFields.add(new TicketFieldVisibility(columnKey, false));
        }
        newTicketSetting.setHiddenTicketFields(newHiddenTicketFields);
        boolean hasKnowledgeBaseAccess = ServerPluginManager.getInstance().isPluginLoaded("knowledgebase") && SystemPermissionChecker.checkAccess((Permission)Permission.valueOfExistingOrCreate((String)"knowledgeBase"));
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData(this.getEventName(), (Object)new NewTicketSettingsResponse(newTicketSetting, hasKnowledgeBaseAccess)));
    }
}

