/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.datasource;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Datasource;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;

@InternalApi
public class TicketPageDataSourceConfiguration
extends BaseDataFactory {
    public static final int TYPE_STATUS = 0;
    public static final String TABLE_TICKETFIELDS = "TicketFields";

    public boolean getReportDataPerInstance() {
        return true;
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Hardcoded for ticket reports")
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        ArrayList<String> columns = new ArrayList<String>();
        List<ColumnInfo> cols = this.getColumns(ts);
        cols.stream().filter(c -> c.getColumnType() == 3).forEach(c -> columns.add(c.getName()));
        List prompts = ts.getInputParameters();
        List<Number> ticketIDs = new ArrayList<Number>();
        if (!prompts.isEmpty()) {
            try {
                PromptField ticketIdField = (PromptField)prompts.get(0);
                Object ticketIdValue = ticketIdField.getPromptValue();
                if (ticketIdValue instanceof Object[]) {
                    ticketIDs = Arrays.stream((Object[])ticketIdValue).filter(Number.class::isInstance).map(Number.class::cast).collect(Collectors.toList());
                } else if (ticketIdValue instanceof Number) {
                    ticketIDs.add((Number)ticketIdValue);
                }
            }
            catch (Exception ticketIdField) {
                // empty catch block
            }
        }
        Set<Integer> ticketIdSet = ticketIDs.stream().map(Number::intValue).collect(Collectors.toSet());
        SimpleResultSet rs = this.getResultSet(columns, ticketIdSet);
        TableData tableData = new TableData((ResultSet)rs);
        return tableData;
    }

    private SimpleResultSet getResultSet(ArrayList<String> columns, final Set<Integer> ticketIdSet) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return null;
        }
        SimpleResultSet rs = new SimpleResultSet(columns.toArray(new String[columns.size()])){
            private final Iterator<Integer> ids;
            {
                super(arg0);
                this.ids = ticketIdSet.iterator();
            }

            @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only reading saved icon files")
            public boolean next() throws SQLException {
                if (this.getRowCount() > 0) {
                    return super.next();
                }
                StatusManager instance = StatusManager.getInstance();
                if (this.ids.hasNext()) {
                    Integer id = this.ids.next();
                    TicketVO ticket = TicketPageDataSourceConfiguration.this.getTicketForId(id);
                    if (ticket != null) {
                        Object[] rowData = new Object[6];
                        rowData[0] = id;
                        rowData[1] = ticket.getSubject();
                        StatusVO statusVO = (StatusVO)instance.get(ticket.getStatusID());
                        rowData[2] = statusVO.getDisplayValue();
                        rowData[3] = TicketPageDataSourceConfiguration.getImage(0, String.valueOf(ticket.getStatusID()));
                        rowData[4] = ticket.hasAttachments();
                        rowData[5] = ticket.getOwnerID();
                        this.getAllRows().add(rowData);
                    }
                    return super.next();
                }
                return super.next();
            }
        };
        return rs;
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        return Collections.singletonMap(TABLE_TICKETFIELDS, new TableSourceInfo(null, null, TABLE_TICKETFIELDS, 20));
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
        if (ts.getDatabaseIdentifier().equals(TABLE_TICKETFIELDS)) {
            cols.add(new ColumnInfo("TicketId", 6));
            cols.add(new ColumnInfo("Subject", 11));
            cols.add(new ColumnInfo("Status", 11));
            cols.add(new ColumnInfo("StatusIcon", 14));
            cols.add(new ColumnInfo("HasAttachment", 8));
            cols.add(new ColumnInfo("UserId", 11));
            cols.add(new ColumnInfo("ticketid", 6, 1, 4, 0));
            cols.add(new ColumnInfo("stepids", 6, 1, 4, 0));
        }
        return cols;
    }

    protected TicketVO getTicketForId(Integer id) {
        return TicketManager.getReader().getTicket(id.intValue());
    }

    private static byte[] getImage(int typeID, String value) {
        ImagesConnector imagesConnector;
        URL stateImage;
        if (value != null && (stateImage = (imagesConnector = (ImagesConnector)ServerPluginManager.getInstance().getSingleInstance(ImagesConnector.class)).getDataImage(typeID, value, 32)) != null) {
            try {
                return IOFunctions.getFileBuffer((URL)stateImage);
            }
            catch (IOException e) {
                HDLogger.error((Object)e);
            }
        }
        return TicketPageDataSourceConfiguration.createEmptyImage();
    }

    private static byte[] createEmptyImage() {
        BufferedImage image = new BufferedImage(32, 32, 2);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            HDLogger.error((Object)ioe);
            return new byte[0];
        }
    }
}

