/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.plugins.ticketlist.api.TicketPageLayout;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageExtensionDescription;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutSpecificSettingsModel;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonData
public class TicketPageLayoutDescription {
    private String layoutKey;
    private String description;
    private String displayName;
    private ArrayList<TicketPageExtensionDescription> extensions;
    private Set<String> hiddenExtensions;
    private String headerIconColumKey;
    private String headerTextColumKey;

    private TicketPageLayoutDescription() {
    }

    public String getLayoutKey() {
        return this.layoutKey;
    }

    public String getHeaderIconColumKey() {
        return this.headerIconColumKey;
    }

    public String getHeaderTextColumKey() {
        return this.headerTextColumKey;
    }

    public ArrayList<TicketPageExtensionDescription> getExtensions() {
        return this.extensions;
    }

    public Set<String> getHiddenExtensions() {
        return this.hiddenExtensions;
    }

    public void setHiddenExtensions(Set<String> hiddenExtensions) {
        this.hiddenExtensions = hiddenExtensions;
    }

    public static TicketPageLayoutDescription fromTicketPageLayout(TicketPageLayout ticketPageLayout, TicketPageLayoutSpecificSettingsModel layoutSpecificSettings) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        List ticketPageExtensions = ServerPluginManager.getInstance().get(TicketPageExtension.class);
        TicketPageLayoutDescription descr = new TicketPageLayoutDescription();
        descr.layoutKey = ticketPageLayout.getKey();
        descr.description = ticketPageLayout.getDescription();
        descr.displayName = ticketPageLayout.getDisplayName();
        descr.hiddenExtensions = new HashSet<String>();
        List<String> extensionKeys = null;
        if (layoutSpecificSettings != null) {
            descr.headerIconColumKey = layoutSpecificSettings.getHeaderIconColumKey();
            descr.headerTextColumKey = layoutSpecificSettings.getHeaderTextColumKey();
            extensionKeys = layoutSpecificSettings.getExtensions();
            if (layoutSpecificSettings.getHiddenExtensions() != null) {
                descr.hiddenExtensions.addAll(layoutSpecificSettings.getHiddenExtensions());
            }
        }
        if (descr.headerIconColumKey == null) {
            descr.headerIconColumKey = Tickets.ATTRIBUTE_STATUS_ID.getKey();
        }
        if (descr.headerTextColumKey == null) {
            descr.headerTextColumKey = Tickets.FIELD_SUBJECT.getKey();
        }
        descr.extensions = new ArrayList();
        if (extensionKeys == null) {
            extensionKeys = new ArrayList<String>();
            extensionKeys.add("ticketdetails");
            extensionKeys.add("ticketowner");
            extensionKeys.add("timeline");
            extensionKeys.add("attachments");
        }
        ArrayList<String> alreadyAddedExtensions = new ArrayList<String>(extensionKeys);
        ticketPageExtensions.forEach(e -> {
            if (!alreadyAddedExtensions.contains(e.getExtensionName()) && !descr.hiddenExtensions.contains(e.getExtensionName())) {
                if (e.isDefaultVisible()) {
                    alreadyAddedExtensions.add(e.getExtensionName());
                } else {
                    descr.hiddenExtensions.add(e.getExtensionName());
                }
            }
        });
        for (String extensionKey : alreadyAddedExtensions) {
            TicketPageExtension ticketPageExtension = ticketPageExtensions.stream().filter(tpe -> extensionKey.equals(tpe.getExtensionName())).findFirst().orElse(null);
            if (ticketPageExtension == null || !ticketPageExtension.isAvailable(currentUserAccount)) continue;
            descr.extensions.add(new TicketPageExtensionDescription(ticketPageExtension.getExtensionName(), ticketPageExtension.getDisplayName(), ticketPageExtension.getDescription()));
        }
        return descr;
    }
}

