/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ai.summarize;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ai.CancelableExecutor;
import com.inet.helpdesk.plugins.ticketlist.server.ai.TicketListAIStructureProvider;
import com.inet.helpdesk.plugins.ticketlist.server.ai.summarize.GetTicketTimelineAITool;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.lib.markdown.MarkDown2Html;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ai.api.AIProviderManager;
import com.inet.plugin.ai.api.AIRequest;
import com.inet.plugin.ai.api.AIResponse;
import com.inet.plugin.ai.api.Communicator;
import com.inet.plugin.ai.api.ResponseHandler;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public class SummarizeExecuter
implements CancelableExecutor {
    private final int ticketID;
    private final String clientId;
    private static final String AI_CHUNK_EVENT = "helpdesk.ai.chunk";
    private AIResponse response;
    private boolean canceled;
    private static final ConfigValue<String> EXTRA_SUMMARIZE_INSTRUCTIONS = new ConfigValue(TicketListAIStructureProvider.AI_SUMMARIZE_EXTRA_INSTRUCTIONS);
    private AIProviderManager manager;

    SummarizeExecuter(int ticketID, String clientId, AIProviderManager manager) {
        this.ticketID = ticketID;
        this.clientId = clientId;
        this.manager = manager;
    }

    public SummarizeExecuter(int ticketID, String clientId) {
        this.ticketID = ticketID;
        this.clientId = clientId;
        this.manager = AIProviderManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getInstantSummary() throws ClientMessageException {
        try {
            if (this.clientId != null) {
                CancelableExecutor.addExecuter((String)this.clientId, (CancelableExecutor)this);
            }
            SummarizeExecuter summarizeExecuter = this;
            synchronized (summarizeExecuter) {
                this.runRequest();
                while (true) {
                    this.wait(60000L);
                    if (this.response == null) {
                        break;
                    }
                    if (this.response.getErrorText() != null) {
                        throw new ClientMessageException(this.response.getErrorText());
                    }
                    String responseText = this.response.getResponseText();
                    if (responseText != null && !"\u2705".equals(responseText)) {
                        String string = responseText = new MarkDown2Html().convert(responseText);
                        return string;
                    }
                    this.response = null;
                }
            }
        }
        catch (ClientMessageException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)th), th);
        }
        finally {
            if (this.clientId != null) {
                CancelableExecutor.removeExecuter((String)this.clientId);
            }
        }
        if (!this.canceled) throw new ClientMessageException("timeout");
        throw new ClientMessageException("timeout");
    }

    public void runRequest() {
        Communicator communicator;
        Boolean useDefault = (Boolean)TicketListAIStructureProvider.AI_SUMMARIZE_USEDEFAULTPROVIDER.getCurrent();
        if (useDefault == null || useDefault.booleanValue()) {
            communicator = this.manager.getDefaultCommunicator();
        } else {
            String providerName = (String)TicketListAIStructureProvider.AI_SUMMARIZE_MANUALPROVIDER.getCurrent();
            if (providerName == null || providerName.isBlank()) {
                return;
            }
            communicator = this.manager.getCommunicator(providerName);
        }
        if (communicator == null) {
            return;
        }
        ResponseHandler handler = new ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(@Nonnull AIResponse response) {
                SummarizeExecuter executer;
                HDLogger.info((Object)("Summary: " + response.getResponseText()));
                SummarizeExecuter summarizeExecuter = executer = SummarizeExecuter.this;
                synchronized (summarizeExecuter) {
                    executer.response = response;
                    executer.notifyAll();
                }
            }
        };
        Object systemPrompt = "    **Role:** You are an AI assistant as part of the customer support, specializing in quick, effective support ticket summaries for customer support agents.\n    **Objective:** When given ticket information, your goal is to provide a concise, prose-based summary of its history, allowing a new agent to rapidly grasp the situation.\n    **Instructions:**\n";
        systemPrompt = (String)systemPrompt + "* **Language:** *ALWAYS* generate the entire response, including all headers and summary content, in **" + ClientLocale.getThreadLocale().getDisplayLanguage(Locale.ENGLISH).toUpperCase() + "**.\n";
        systemPrompt = (String)systemPrompt + "* **Information Source:** Use *ONLY* the provided ticket history. **DO NOT** reference any other source.\n    * If you cannot identify a problem, you are allowed to respond with phrases like 'there is no problem' or 'I cannot help you'.\n* **Content Extraction:** Identify and extract only the most important details, including:\n    * The core customer problem(s). If more than one problem, *EACH* problem should be listed separately.\n    * All previous attempts at resolution.\n    * Any key interactions, escalations, or relevant customer information.\n    * The current status of the ticket.\n* **Output Structure:** Response *MUST* strictly adhere to Markdown syntax, with clear and distinct sections. All section headers *MUST* use level 3 Markdown headings.\n    * Allowed sections are \"Problem\", \"Approach to Solution\", \"Solution\", \"Status\" for ENGLISH language, translated into **" + ClientLocale.getThreadLocale().getDisplayLanguage(Locale.ENGLISH).toUpperCase() + "        **.\n        * Section titles must always start with a capital letter.\n        * If a section has *NO* valuable content, *DO NOT* show the section!\n    * **Parameter Replacement:** **NEVER** output placeholders such as {userDisplayName}. If the corresponding value is not available, *OMIT* the reference entirely.\n    * **Irrelevant Information:** Exclude courtesy phrases and generic greetings unless they contain relevant information.\n    * **Formatting:**\n        * Present all summaries as continuous prose, **NEVER** as a list or bullet points.\n        * Use Markdown for formatting.\n        * **Bold** critical information (e.g., key dates, specific errors, customer names, significant actions, current status).\n    * **Conciseness:** Be as brief as possible without omitting essential context. Prioritize clarity and directness.\n    * **Tone:** *ALWAYS* maintain a professional and informative tone. *ALWAYS* use the provided **{userDisplayName}** when referring to customer or agents.\n";
        String extra = (String)EXTRA_SUMMARIZE_INSTRUCTIONS.get();
        if (extra != null && !extra.isBlank()) {
            systemPrompt = (String)systemPrompt + "\n\n" + extra.trim();
        }
        AIRequest request = new AIRequest("Ticketlist Summary", "" + this.ticketID, handler, null, List.of(new GetTicketTimelineAITool()));
        request.setSystemPrompt((String)systemPrompt);
        request.setForceTool(true);
        if (this.clientId != null) {
            request.setStreaming(true);
            request.setStreamHandler(chunk -> {
                AIChunk aiChunk = new AIChunk();
                aiChunk.id = chunk.getChunkingGroupGUID().toString();
                aiChunk.text = chunk.getText();
                WebSocketEventHandler.getInstance().sendEvent(this.clientId, () -> new WebSocketEventData(AI_CHUNK_EVENT, (Object)aiChunk));
            });
        }
        communicator.runRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExecution() {
        SummarizeExecuter executer;
        SummarizeExecuter summarizeExecuter = executer = this;
        synchronized (summarizeExecuter) {
            executer.response = null;
            executer.canceled = true;
            executer.notifyAll();
        }
    }

    @JsonData
    public static class AIChunk {
        private String id;
        private String text;
    }
}

