/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server;

import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererExtension;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ResourceIdApplyActionRendererExtension
implements ApplyActionRendererExtension {
    @Override
    public List<String> getUpdateRendererIds(List<String> rendererIds, @Nonnull ActionVO action, TicketVO ticket) {
        switch (action.getId()) {
            case 8: {
                rendererIds.add(0, TicketFieldRendererId.keepstatus.name());
                rendererIds.add(0, TicketFieldRendererId.resourceid.name());
                break;
            }
            case 5: {
                rendererIds.add(0, TicketFieldRendererId.resourceid.name());
                break;
            }
            default: {
                if (101 != action.getStatusID()) break;
                rendererIds.add(0, TicketFieldRendererId.keepstatus.name());
                rendererIds.add(0, TicketFieldRendererId.resourceid.name());
            }
        }
        return rendererIds;
    }

    @Override
    public Map<String, String> getInitialProperties(ActionVO action, TicketVO ticket, Integer stepId, String flag, ReaStepTextVO stepText, ExtensionArguments extensionArguments) {
        HashMap<String, String> initialProperties = new HashMap<String, String>();
        if (5 == action.getId() || 8 == action.getId() || 101 == action.getStatusID()) {
            ExtensionArguments.ResourceActionExtensionData resourceData;
            if (ticket != null) {
                GUID resourceID = ticket.getResourceID();
                if (resourceID != null) {
                    UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resourceID);
                    if (resource != null) {
                        initialProperties.put(TicketFieldRendererId.resourceid.name(), new Json().toJson((Object)new SelectOption(resource.getID().toString(), resource.getDisplayName(), HDUsersAndGroups.getResourceIconKey((UserGroupInfo)resource), 0)));
                    }
                } else {
                    UserGroupInfo resource;
                    CategoryVO categoryVO;
                    Integer categoryID = ticket.getCategoryID();
                    if (categoryID != null && (categoryVO = (CategoryVO)CategoryManager.getInstance().get(categoryID.intValue())) != null && (resourceID = this.getResourceIDOfCategory(categoryVO)) != null && (resource = UserGroupManager.getInstance().getGroup(resourceID)) != null) {
                        initialProperties.put(TicketFieldRendererId.resourceid.name(), new Json().toJson((Object)new SelectOption(resource.getID().toString(), resource.getDisplayName(), HDUsersAndGroups.getResourceIconKey((UserGroupInfo)resource), 0)));
                    }
                }
            }
            if (extensionArguments != null && (resourceData = (ExtensionArguments.ResourceActionExtensionData)extensionArguments.get(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA)) != null) {
                GUID targetResID = resourceData.getTargetResID();
                UserGroupInfo resource = UserGroupManager.getInstance().getGroup(targetResID);
                if (resource != null) {
                    initialProperties.put(TicketFieldRendererId.resourceid.name(), new Json().toJson((Object)new SelectOption(resource.getID().toString(), resource.getDisplayName(), HDUsersAndGroups.getResourceIconKey((UserGroupInfo)resource), 0)));
                    initialProperties.put(TicketFieldRendererId.keepstatus.name(), String.valueOf(!resourceData.shouldChangeTicketStatus()));
                }
            }
        }
        return initialProperties;
    }

    private GUID getResourceIDOfCategory(CategoryVO categoryVO) {
        if (categoryVO != null) {
            CategoryVO parentCategory;
            UserGroupInfo resource;
            int resourceID = categoryVO.getResourceID();
            if (resourceID > 0 && (resource = HDUsersAndGroups.getResource((int)resourceID)) != null) {
                return resource.getID();
            }
            Integer parentCategoryID = categoryVO.getParentCategoryID();
            if (parentCategoryID != null && (parentCategory = (CategoryVO)CategoryManager.getInstance().get(parentCategoryID.intValue())) != null) {
                return this.getResourceIDOfCategory(parentCategory);
            }
        }
        return null;
    }

    @Override
    public void prepareReastepActionData(MutableReaStepData stepData, MutableReaStepText stepText, ExtensionArguments extensionArgs, ActionVO action, Map<String, String> values) {
        block7: for (Map.Entry<String, String> entry : values.entrySet()) {
            switch (entry.getKey()) {
                case "resourceid": 
                case "keepstatus": {
                    if (extensionArgs.containsExtArg(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA)) break;
                    String resourceValue = values.get(TicketFieldRendererId.resourceid.name());
                    String keepStatusValue = values.get(TicketFieldRendererId.keepstatus.name());
                    if (StringFunctions.isEmpty((String)resourceValue)) break;
                    SelectOption selectOption = (SelectOption)new Json().fromJson(resourceValue, SelectOption.class);
                    GUID resourceGUID = GUID.valueOf((String)selectOption.getValue());
                    UserGroupInfo resource = null;
                    if (resourceGUID != null) {
                        resource = HelpDeskUserGroupManager.getInstance().getGroup(resourceGUID);
                    }
                    if (resource == null) break;
                    int actionId = action.getId();
                    if (actionId == 8 || 101 == action.getStatusID()) {
                        boolean keepStatus = Boolean.parseBoolean(keepStatusValue);
                        extensionArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket((GUID)resource.getID(), (!keepStatus ? 1 : 0) != 0));
                    }
                    if (actionId != 5) continue block7;
                    extensionArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)ExtensionArguments.ResourceActionExtensionData.forAuthorizationOfTicket((GUID)resource.getID()));
                    break;
                }
            }
        }
    }

    @Override
    public SelectOptionResult getSelectOptions(String fieldKey, String searchTerm, int chunkSize, int currentSize, List<Integer> ticketIds) {
        FieldEditDefinition editDefinition;
        TicketFieldDefinition fieldDefinition;
        if (TicketFieldRendererId.resourceid.name().equals(fieldKey) && (fieldDefinition = (TicketFieldDefinition)DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class).stream().filter(tfd -> tfd.getKey().equals(fieldKey)).findFirst().orElse(null)) != null && (editDefinition = fieldDefinition.getEditDefinition()) instanceof SelectEditDefinition) {
            List tickets = null;
            if (ticketIds != null && !ticketIds.isEmpty()) {
                tickets = ticketIds.stream().filter(tId -> tId != null).map(tId -> TicketManager.getReader().getTicket(tId.intValue())).collect(Collectors.toList());
            }
            return ((SelectEditDefinition)editDefinition).getSelectOptions(tickets, searchTerm, chunkSize, currentSize);
        }
        return null;
    }
}

