/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist;

import com.inet.authentication.AccessForbiddenException;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.remote.gui.angular.AngularApplicationServlet;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.ModuleMetaData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;

public class TicketListAngularApplicationServlet
extends AngularApplicationServlet {
    public TicketListAngularApplicationServlet() {
        super("/ticketlist");
    }

    public void handlePost(HttpServletRequest request, HttpServletResponse response, String pathInfo, HashMap<String, String> replace) throws IOException {
        String newTicketData = request.getParameter("newTicketData");
        if (newTicketData != null && !newTicketData.isBlank()) {
            if (replace == null) {
                replace = new HashMap();
            }
            replace.put("NEW_TICKET_DATA", newTicketData);
            this.handleGet(request, response, pathInfo, replace);
            return;
        }
        super.handlePost(request, response, pathInfo, replace);
    }

    public void handleGet(HttpServletRequest request, HttpServletResponse response, String pathInfo, HashMap<String, String> replace) throws IOException {
        UserAccount user = UserManager.getInstance().getCurrentUserAccount();
        if (user != null && user.getAccountType() == UserAccountType.Temp && !HDUsersAndGroups.isSupporter((UserAccount)user)) {
            throw new AccessForbiddenException();
        }
        if (replace == null) {
            replace = new HashMap();
        }
        replace.putIfAbsent("NEW_TICKET_DATA", "undefined");
        ModuleMetaData moduleMetaData = new ModuleMetaData(this.getPath(), ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketlistapp.html"));
        moduleMetaData.setName(TicketListServerPlugin.PLUGIN_MSG.getMsg("moduleName", new Object[0]));
        moduleMetaData.setPWAEnabled(true);
        moduleMetaData.setShowPwaPrompt(true);
        moduleMetaData.addJsPath("helpdesk.ticket.js");
        moduleMetaData.addJsPath("helpdesk.ticket.extensions.js");
        moduleMetaData.addJsPath("helpdesk.attachmentdisplay.js");
        AngularContentService.serveTemplate((HttpServletRequest)request, (HttpServletResponse)response, replace, (ModuleMetaData)moduleMetaData);
    }
}

