/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.config.autotext.handler.AutoTextAttachmentHelper;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.AutoTextDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.EditDuration;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.plugins.ticketlist.api.editing.AdditionalCloseActions;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.helpdesk.plugins.ticketlist.api.fieldconditions.FieldConditionManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetEditActionFieldsData;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetEditActionFieldsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.plugins.ticketlist.server.handler.MandatoryFieldsEvaluatorForGetEditActionFields;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

public class GetEditActionFields
extends AbstractTicketListHandler<GetEditActionFieldsData, GetEditActionFieldsResponse> {
    private final MandatoryFieldsEvaluatorForGetEditActionFields mandatoryFieldsEvaluator;
    private FieldConditionManager fieldConditionManager;

    public GetEditActionFields(@Nonnull MandatoryFieldsEvaluatorForGetEditActionFields mandatoryFieldsEvaluator, @Nonnull FieldConditionManager fieldConditionManager) {
        this.mandatoryFieldsEvaluator = mandatoryFieldsEvaluator;
        this.fieldConditionManager = fieldConditionManager;
    }

    public String getMethodName() {
        return "ticketpage.geteditactionfields";
    }

    @Override
    protected GetEditActionFieldsResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetEditActionFieldsData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        TicketAccessInfo ticketAccessInfo;
        if (input.getTicketIds() == null || input.getTicketIds().isEmpty()) {
            HashMap<String, String> initialProperties = new HashMap<String, String>();
            List<String> renderers = Collections.emptyList();
            List<AdditionalCloseActions> additionalCloseActions = Collections.emptyList();
            List<AutoTextDescription> autoTexts = Collections.emptyList();
            ArrayList<FieldEditDescription> mandatoryFields = new ArrayList<FieldEditDescription>();
            HashMap<String, String> mandatoryValues = new HashMap<String, String>();
            HashMap<String, String> mandatoryEditHints = new HashMap<String, String>();
            return new GetEditActionFieldsResponse(initialProperties, null, renderers, additionalCloseActions, false, null, autoTexts, null, mandatoryFields, mandatoryValues, mandatoryEditHints, null);
        }
        if (input.getActionId().equals("split")) {
            int firstTicketId = input.getTicketIds().get(0);
            TicketVO firstTicket = TicketManager.getReaderForSystem().getTicket(firstTicketId);
            HashMap<String, String> mandatoryValues = new HashMap<String, String>();
            MandatoryFieldsEvaluatorForGetEditActionFields.MandatoryFieldsList mandatoryFields = new MandatoryFieldsEvaluatorForGetEditActionFields.MandatoryFieldsList();
            if (firstTicket.isDispatched()) {
                mandatoryFields = this.mandatoryFieldsEvaluator.evaluate((ActionVO)ActionManager.getInstance().get(5), input.getTicketIds(), mandatoryValues);
            }
            HashMap<String, String> initialProperties = ApplyActionRendererProvider.getInstance().getInitialProperties(input.getClientId(), (ActionVO)ActionManager.getInstance().get(-22), firstTicket, input.getStepId(), input.getFlag(), null, null);
            List<String> renderers = ApplyActionRendererProvider.getInstance().getRendererIds((ActionVO)ActionManager.getInstance().get(-22), firstTicket);
            ArrayList<AdditionalCloseActions> additionalCloseActions = new ArrayList<AdditionalCloseActions>();
            ArrayList<AutoTextDescription> autoTexts = new ArrayList<AutoTextDescription>();
            return new GetEditActionFieldsResponse(initialProperties, null, renderers, additionalCloseActions, false, null, autoTexts, null, mandatoryFields.getFields(), mandatoryValues, mandatoryFields.getEditHints(), null);
        }
        TicketAccessInformationsProvider ticketAccessInformationsProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
        boolean isInTicketDetailsPage = false;
        if (input.getTicketIds().size() == 1 && (ticketAccessInfo = ticketAccessInformationsProvider.getTicketAccessInfo(input.getTicketIds().get(0).intValue())) != null) {
            boolean present = ticketAccessInfo.getReadSessions().stream().filter(s -> input.getClientId().equals(s.getClientID())).findAny().isPresent();
            if (!present) {
                TicketAccessInfo.TicketAccessor writeSession = ticketAccessInfo.getWriteSession();
                present = writeSession != null && input.getClientId().equals(writeSession.getClientID());
            }
            isInTicketDetailsPage = present;
        }
        try {
            boolean supportsEditDuration;
            for (Integer ticketId : input.getTicketIds()) {
                boolean accessTicketWrite = ticketAccessInformationsProvider.accessTicketWrite(input.getClientId(), ticketId.intValue());
                if (!accessTicketWrite) {
                    throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.lock.failed", new Object[]{String.valueOf(ticketId)}));
                }
                ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(input.getActionId(), ticketId.intValue());
                ActionCheckError errorMessage = TicketManager.getTicketActionChecker().checkAction(action, ticketId.intValue());
                if (errorMessage == null) continue;
                throw new ClientMessageException(errorMessage.getErrorMessage());
            }
            int firstTicketId = input.getTicketIds().get(0);
            TicketVO firstTicket = TicketManager.getReaderForSystem().getTicket(firstTicketId);
            ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(input.getActionId(), firstTicketId);
            HashMap<String, String> initialProperties = ApplyActionRendererProvider.getInstance().getInitialProperties(input.getClientId(), action, firstTicket, input.getStepId(), input.getFlag(), null, null);
            List<String> renderers = ApplyActionRendererProvider.getInstance().getRendererIds(action, firstTicket);
            List<AdditionalCloseActions> additionalCloseActions = ApplyActionRendererProvider.getInstance().getAdditionalCloseActions(action, firstTicket, isInTicketDetailsPage);
            boolean bl = supportsEditDuration = action.getId() != -12 && action.getId() != -22 && 2 != (Integer)ApplyActionRendererProvider.EFFORTTIME.get();
            if (!HDUsersAndGroups.isSupporter((UserAccount)currentUser)) {
                supportsEditDuration = false;
            }
            List initialAttachments = null;
            List<AutoTextDescription> autoTexts = null;
            HashMap<Integer, List<SavedAttachmentData>> autoTextAttachments = new HashMap<Integer, List<SavedAttachmentData>>();
            AutoTextManager autoTextManager = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
            List autoTextVOs = autoTextManager.getAutoTexts(input.getTicketIds().get(0), input.getStepId(), Integer.valueOf(action.getId()));
            if (autoTextVOs != null) {
                AutoTextVO signature;
                autoTexts = TicketFunctions.convertAutoTexts(autoTextVOs);
                if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                    for (AutoTextVO autoTextVO : autoTextVOs) {
                        List attachments = AutoTextAttachmentHelper.getAutoTextAttachments((int)autoTextVO.getId());
                        autoTextAttachments.put(autoTextVO.getId(), attachments);
                    }
                }
                if ((action.getId() == -7 || 211 == action.getStatusID()) && (signature = autoTextManager.getAutoUserSignature(input.getTicketIds().get(0), input.getStepId())) != null && ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                    ReaStepTextVO reaStepText;
                    initialAttachments = AutoTextAttachmentHelper.getAutoTextAttachments((int)signature.getId());
                    if (!initialAttachments.isEmpty() && input.getStepId() != null && (reaStepText = TicketManager.getReader().getReaStepText(input.getStepId().intValue())) != null && !reaStepText.hasHtmlContent()) {
                        initialAttachments.forEach(a -> a.setEmbedded(false));
                    }
                    initialProperties.put(TicketFieldRendererId.attachments.name(), String.valueOf(initialAttachments.size()));
                }
            }
            boolean allowsCustomEndDate = !ApplyActionRendererProvider.ACTIONS_WITHOUT_CUSTOM_DURATION_ENDDATE.contains(action.getId()) && !ApplyActionRendererProvider.STATUS_WITHOUT_CUSTOM_DURATION_ENDDATE.contains(action.getStatusID());
            HashMap<String, String> mandatoryValues = new HashMap<String, String>();
            MandatoryFieldsEvaluatorForGetEditActionFields.MandatoryFieldsList mandatoryFields = this.mandatoryFieldsEvaluator.evaluate(action, input.getTicketIds(), mandatoryValues);
            return new GetEditActionFieldsResponse(initialProperties, initialAttachments, renderers, additionalCloseActions, supportsEditDuration, new EditDuration(null, null, allowsCustomEndDate), autoTexts, autoTextAttachments, mandatoryFields.getFields(), mandatoryValues, mandatoryFields.getEditHints(), this.fieldConditionManager.getConditionsForAction(action, input.getTicketIds()));
        }
        catch (Throwable t) {
            try {
                if (t instanceof ClientMessageException) {
                    throw t;
                }
                HDLogger.error((Object)t);
                throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)t));
            }
            catch (Throwable throwable) {
                if (input.getTicketIds().size() == 1) {
                    ticketAccessInformationsProvider.accessTicketRead(input.getClientId(), input.getTicketIds().get(0).intValue());
                } else {
                    ticketAccessInformationsProvider.leaveAllTickets(input.getClientId());
                }
                throw throwable;
            }
        }
    }
}

