/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketFieldVisibility;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.UsersAndGroups;
import java.util.ArrayList;

@JsonData
public class PreviewSettings {
    private boolean lasttext = false;
    private boolean laststeps = false;
    private int previewWidth = 60;
    private int previewHeight = 60;
    private ArrayList<TicketFieldVisibility> hiddenTicketFields = new ArrayList<TicketFieldVisibility>(){
        {
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_STATUS_ID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_OWNER_GUID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_CATEGORY_ID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_PRIORITY_ID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_INQUIRY_DATE.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_RESOURCE_GUID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_SUBJECT.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.FIELD_ITIL_ID.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.FIELD_IDENTIFIER.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.FIELD_CLASSIFICATION_ID.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.FIELD_TARGET_TIME.getKey(), true));
            this.add(new TicketFieldVisibility("custom1", true));
            this.add(new TicketFieldVisibility("custom2", true));
            this.add(new TicketFieldVisibility("custom3", true));
            this.add(new TicketFieldVisibility("custom4", true));
            this.add(new TicketFieldVisibility("custom5", true));
            this.add(new TicketFieldVisibility("custom6", true));
            this.add(new TicketFieldVisibility("custom7", true));
            this.add(new TicketFieldVisibility(Tickets.FIELD_DEADLINE.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_WIEDERVORLAGEDATE.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_TERMINVEREINBARUNG.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_ATTACHMENTS.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_LAST_CHANGED_BY_GUID.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_LAST_CHANGED.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_LAST_EDITOR_GUID.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_SUM_TIME.getKey(), true));
            this.add(new TicketFieldVisibility("ticketid", true));
            this.add(new TicketFieldVisibility("processid", true));
            this.add(new TicketFieldVisibility("processtask", true));
            this.add(new TicketFieldVisibility("itillinkcount", true));
            this.add(new TicketFieldVisibility("preview", true));
            this.add(new TicketFieldVisibility("ticketowner." + UsersAndGroups.FIELD_FIRSTNAME.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner." + UsersAndGroups.FIELD_LASTNAME.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner.department", true));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_CLASS_ID.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner." + UsersAndGroups.FIELD_TELEPHONE.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_LOCATION_ID.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_LOCATION_ID.getKey() + ".info", true));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_COMPUTER_NAME.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_COST_CENTRE.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner.custom1", true));
            this.add(new TicketFieldVisibility("ticketowner.custom2", true));
            this.add(new TicketFieldVisibility("ticketowner.custom3", true));
            this.add(new TicketFieldVisibility("ticketowner.custom4", true));
            this.add(new TicketFieldVisibility("ticketowner.custom5", true));
            this.add(new TicketFieldVisibility("ticketowner.custom6", true));
        }
    };

    public boolean isLasttext() {
        return this.lasttext;
    }

    public boolean isLaststeps() {
        return this.laststeps;
    }

    public ArrayList<TicketFieldVisibility> getHiddenTicketFields() {
        return this.hiddenTicketFields;
    }

    public void setHiddenTicketFields(ArrayList<TicketFieldVisibility> hiddenTicketFields) {
        this.hiddenTicketFields = hiddenTicketFields;
    }

    public void merge(PreviewSettings p) {
        if (p == null) {
            return;
        }
        ArrayList<TicketFieldVisibility> oldHiddenField = this.hiddenTicketFields;
        this.hiddenTicketFields = p.hiddenTicketFields;
        if (oldHiddenField != null && this.hiddenTicketFields != null) {
            for (TicketFieldVisibility tfv : oldHiddenField) {
                if (this.hiddenTicketFields.contains(tfv)) continue;
                this.hiddenTicketFields.add(tfv);
            }
        }
        this.lasttext = p.lasttext;
        this.laststeps = p.laststeps;
        this.previewHeight = p.previewHeight;
        this.previewWidth = p.previewWidth;
    }
}

