/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.UnbundleTicketRequest;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;

public class UnbundleTicket
extends AbstractTicketListHandler<UnbundleTicketRequest, Void> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, UnbundleTicketRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        Void void_;
        TicketAccessInformationsProvider ticketAccess = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
        try {
            if (!ticketAccess.accessTicketWrite(input.getClientId(), input.getMasterTicketId())) {
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.lock.failed", new Object[]{String.valueOf(input.getMasterTicketId())}));
            }
            if (!ticketAccess.accessTicketWrite(input.getClientId(), input.getSlaveTicketId())) {
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.lock.failed", new Object[]{String.valueOf(input.getSlaveTicketId())}));
            }
            try {
                TicketManager.getManipulator().unbundleTickets(input.getMasterTicketId(), Collections.singletonList(input.getSlaveTicketId()));
            }
            catch (IllegalArgumentException | IllegalStateException iae) {
                TicketListServerPlugin.LOGGER.debug((Object)iae);
                throw new ClientMessageException(iae.getMessage());
            }
            void_ = null;
        }
        catch (Throwable throwable) {
            ticketAccess.leaveTickets(input.getClientId(), new int[]{input.getSlaveTicketId()});
            throw throwable;
        }
        ticketAccess.leaveTickets(input.getClientId(), new int[]{input.getSlaveTicketId()});
        return void_;
    }

    public String getMethodName() {
        return "ticketlist.extension.links.unbundleticket";
    }
}

