/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.export.TicketExporter;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.ReportException;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class TicketExport
extends AbstractTicketListHandler<Void, Void> {
    public String getMethodName() {
        return "ticketlist.export";
    }

    @Override
    public short getMethodType() {
        return 2;
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, Void input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        String ticketIdStr = request.getParameter("ticketid");
        if (StringFunctions.isEmpty((String)ticketIdStr)) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.novalidticketid", new Object[0]));
        }
        int ticketId = -1;
        try {
            ticketId = Integer.parseInt(ticketIdStr);
        }
        catch (NumberFormatException nfe) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.novalidticketid", new Object[0]));
        }
        TicketVO ticket = null;
        try {
            ticket = TicketManager.getReader().getTicket(ticketId);
        }
        catch (AccessDeniedException ade) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.novalidticketid", new Object[0]));
        }
        if (ticket == null) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.novalidticketid", new Object[0]));
        }
        try {
            ServletUtils.setContentDisposition((HttpServletResponse)response, (String)(ticketId + ".zip"), (boolean)false);
            this.startExport(response, ticket);
        }
        catch (Throwable t) {
            TicketListServerPlugin.LOGGER.error(t);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)t));
        }
        return null;
    }

    protected void startExport(HttpServletResponse response, TicketVO ticket) throws IOException, ReportException, SQLException {
        new TicketExporter().exportTicketToStream(ticket, (OutputStream)response.getOutputStream());
    }
}

