/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.DuplicateRange;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.StepDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.UserIdentifier;
import com.inet.helpdesk.plugins.ticketlist.server.data.SearchTicketRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.data.SearchTicketResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketSearchResult;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketPageSettings;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchTicket
extends AbstractTicketListHandler<SearchTicketRequestData, SearchTicketResponseData> {
    private static final int MAX_SEARCH_RESULTS = 200;

    public String getMethodName() {
        return "ticketpage.searchTicket";
    }

    @Override
    protected SearchTicketResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, SearchTicketRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        TicketVO ticket = TicketManager.getReader().getTicket(input.getTicketID());
        String term = input.getTerm();
        if (term == null || ticket == null) {
            return null;
        }
        boolean hideDuplicateContent = TicketPageSettings.getPageSettings(currentUser).isHideDuplicateContent();
        ArrayList<TicketSearchResult> results = new ArrayList<TicketSearchResult>();
        TicketReader ticketReader = TicketManager.getReader();
        List reaStepVOs = ticketReader.getReaStepsForTicket(ticket.getID(), BundleStepsFilter.WITH_BUNDLE_STEPS);
        block0: for (ReaStepVO reaStepVO : reaStepVOs) {
            List duplicateContentRanges;
            ReaStepTextVO reaStepText;
            String partDetail;
            Cutout cutoutDetail;
            StepDescription stepDescription = TicketFunctions.convertToStepDescription(reaStepVO, Collections.emptySet());
            UserIdentifier userIdent = stepDescription.getUserIdentifier();
            ActionDescription actionDescr = stepDescription.getAction();
            int count = 0;
            int index = -1;
            if (userIdent != null) {
                if (userIdent.getDisplayName() != null && (index = userIdent.getDisplayName().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                    cutoutDetail = this.generateCutout(userIdent.getDisplayName(), term, index);
                    partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                    results.add(new TicketSearchResult("useridentifier", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
                }
                if (userIdent.getEmailAdress() != null && (index = userIdent.getEmailAdress().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                    cutoutDetail = this.generateCutout(userIdent.getEmailAdress(), term, index);
                    partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                    results.add(new TicketSearchResult("useridentifier", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
                }
            }
            if ((index = actionDescr.getDisplayName().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                cutoutDetail = this.generateCutout(actionDescr.getDisplayName(), term, index);
                partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                results.add(new TicketSearchResult("actionname", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
            }
            if ((index = stepDescription.getDescription().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                cutoutDetail = this.generateCutout(stepDescription.getDescription(), term, index);
                partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                results.add(new TicketSearchResult("description", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
            }
            if (stepDescription.getDuration() != null && (index = stepDescription.getDuration().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                cutoutDetail = this.generateCutout(stepDescription.getDuration(), term, index);
                partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                results.add(new TicketSearchResult("duration", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
            }
            if ((index = stepDescription.getEmailSenderAddress().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                cutoutDetail = this.generateCutout(stepDescription.getEmailSenderAddress(), term, index);
                partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                results.add(new TicketSearchResult("emailSenderAddress", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
            }
            if ((index = stepDescription.getEmailReceiverAddresses().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                cutoutDetail = this.generateCutout(stepDescription.getEmailReceiverAddresses(), term, index);
                partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                results.add(new TicketSearchResult("emailReceiverAddresses", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
            }
            if ((index = stepDescription.getEmailCCAdresses().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                cutoutDetail = this.generateCutout(stepDescription.getEmailCCAdresses(), term, index);
                partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                results.add(new TicketSearchResult("emailCCAdresses", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
            }
            if ((index = stepDescription.getEmailBCCAdresses().toLowerCase().indexOf(term.toLowerCase(), 0)) != -1) {
                cutoutDetail = this.generateCutout(stepDescription.getEmailBCCAdresses(), term, index);
                partDetail = this.replaceOccuranceAtIndex(cutoutDetail.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", index - cutoutDetail.getOffset());
                results.add(new TicketSearchResult("emailBCCAdresses", reaStepVO.getID(), partDetail, userIdent, actionDescr, reaStepVO.getEndDate()));
            }
            if ((reaStepText = ticketReader.getReaStepText(reaStepVO.getID())) == null) continue;
            Object textContent = reaStepText.getText();
            List list = duplicateContentRanges = hideDuplicateContent ? (List)reaStepVO.getValue((ReaStepField)ReaStepVO.FIELD_DUPLICATED_CONTENT) : null;
            if (duplicateContentRanges != null && !duplicateContentRanges.isEmpty()) {
                TicketFunctions.removeDuplicateRangesFromHiddenSteps(duplicateContentRanges, reaStepVOs);
                duplicateContentRanges.sort((a, b) -> Integer.compare(a.getFrom(), b.getFrom()));
                for (int i = duplicateContentRanges.size() - 1; i >= 0; --i) {
                    DuplicateRange range = (DuplicateRange)duplicateContentRanges.get(i);
                    if (range.getTo() > ((String)textContent).length()) continue;
                    textContent = ((String)textContent).substring(0, range.getFrom()) + " " + ((String)textContent).substring(range.getTo());
                }
            }
            if (reaStepText.hasHtmlContent()) {
                HtmlConverter.ConvertResult html2text = HtmlConverter.html2text((String)textContent, (int)-1);
                textContent = html2text.getContent();
            }
            if (StringFunctions.isEmpty((String)textContent)) continue;
            textContent = ((String)textContent).replace("\n", " ").replace("\r", "");
            int idx = ((String)(textContent = ((String)textContent).replace("<", "&lt;").replace(">", "&gt;"))).toLowerCase().indexOf(term.toLowerCase(), 0);
            if (idx == -1 || idx < 0) continue;
            Cutout cutout = this.generateCutout((String)textContent, term, idx);
            while (cutout != null) {
                String part = this.replaceOccuranceAtIndex(cutout.getPart(), term, "</div></div><b class='stepsearchhighlight'>", "</b><div>", idx - cutout.getOffset());
                TicketSearchResult result = new TicketSearchResult(String.valueOf(++count), reaStepVO.getID(), part, userIdent, actionDescr, reaStepVO.getEndDate());
                results.add(result);
                idx = ((String)textContent).toLowerCase().indexOf(term.toLowerCase(), idx + term.length());
                cutout = idx >= 0 ? this.generateCutout((String)textContent, term, idx) : null;
                if (results.size() < 200) continue;
                break block0;
            }
        }
        return new SearchTicketResponseData(term, results);
    }

    private Cutout generateCutout(String textContent, String term, int idx) {
        int i;
        int startIdx = idx;
        int endIdx = idx + term.length();
        for (i = 0; i < 5; ++i) {
            if ((startIdx = textContent.substring(0, startIdx).lastIndexOf(" ")) < 0) {
                startIdx = 0;
                break;
            }
            if (i != 4 || idx - startIdx >= 50) continue;
            --i;
        }
        for (i = 0; i < 5; ++i) {
            int nextIdx = textContent.substring(endIdx).indexOf(" ");
            if (nextIdx < 0) {
                endIdx = textContent.length();
                break;
            }
            endIdx = endIdx + nextIdx + 1;
            if (i != 4 || endIdx - idx + term.length() >= 50) continue;
            --i;
        }
        Object part = textContent.substring(startIdx, endIdx);
        int offset = startIdx;
        if (startIdx > 0) {
            part = "..." + (String)part;
            offset -= 3;
        }
        if (endIdx < textContent.length()) {
            part = (String)part + "...";
        }
        return new Cutout((String)part, offset);
    }

    private String replaceOccuranceAtIndex(String textContent, String term, String preTag, String postTag, int index) {
        Object prefix = textContent.substring(0, index);
        if (((String)prefix).endsWith(" ")) {
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1) + "&nbsp;";
        }
        String match = textContent.substring(index, index + term.length());
        Object postfix = textContent.substring(index + term.length());
        if (((String)postfix).startsWith(" ")) {
            postfix = "&nbsp;" + ((String)postfix).substring(1);
        }
        return "<div><div>" + (String)prefix + preTag + match + postTag + (String)postfix + "</div>";
    }

    private class Cutout {
        private String part;
        private int offset;

        public Cutout(String part, int offset) {
            this.part = part;
            this.offset = offset;
        }

        public String getPart() {
            return this.part;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

