/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.ticketlist.api.data.EmailUser;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetEmailRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetEmailResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagActive;
import com.inet.usersandgroups.user.search.SearchTagLocked;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

public class GetEmail
extends AbstractTicketListHandler<GetEmailRequestData, GetEmailResponseData> {
    private static final int MAX_ENTRIES = 10000;
    private static final ConfigValue<Integer> USER_ACCESS_FILTER = new ConfigValue(HDConfigKeys.USER_ACCESS_FILTER);

    public String getMethodName() {
        return "applyaction_getemail";
    }

    @Override
    protected GetEmailResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, GetEmailRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        SearchID searchID = new SearchID((Object)(this.getMethodName() + "_" + request.getSession().getId() + (input.getSearchID() != null ? input.getSearchID() : "")));
        ArrayList boostingExpressions = new ArrayList();
        ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
        additionalExpressions.add(new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagActive.valueAsString((boolean)true)));
        additionalExpressions.add(new SearchCondition("locked", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagLocked.valueAsInt((boolean)false)));
        additionalExpressions.add(new SearchCondition("email", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        UserManager manager = UserManager.getInstance();
        SearchResult searchResult = manager.searchAsUser(input.getSearchTerm(), additionalExpressions, boostingExpressions, 20000, searchID);
        if (searchResult.getEntries().isEmpty() && searchResult.isPartialResult()) {
            return null;
        }
        ArrayList<EmailUser> userEmailEntries = new ArrayList<EmailUser>();
        int currentSize = input.getCurrentSize();
        int totalCount = 0;
        if (!StringFunctions.isEmpty((String)input.getSearchTerm()) && !StringFunctions.isEmpty((String)input.getCustomvalue())) {
            userEmailEntries.add(new EmailUser(null, input.getCustomvalue(), "<span>" + StringFunctions.encodeHTML((String)input.getCustomvalue()) + "</span>", null, input.getCustomvalue()));
            ++totalCount;
        }
        int end = input.getTargetSize();
        for (SearchResultEntry searchEntry : searchResult.getEntries()) {
            List validEmailAddresses;
            UserAccount userAccount = manager.getUserAccount((GUID)searchEntry.getId());
            String value = (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
            if (value == null || (validEmailAddresses = EmailAddressHelper.get().getValidEmailAddressesFrom(value)).isEmpty()) continue;
            for (String email : validEmailAddresses) {
                if (userEmailEntries.size() < end) {
                    userEmailEntries.add(new EmailUser(userAccount.getID(), userAccount.getDisplayName(), searchEntry.getFirstResultLine(), searchEntry.getSecondResultLine(), email));
                }
                ++totalCount;
            }
        }
        if (currentSize > (end = Math.min(end, totalCount))) {
            currentSize = end;
        }
        return new GetEmailResponseData(userEmailEntries.subList(currentSize, end), totalCount, input.getRequestNumber());
    }
}

