/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.PreviewSettings;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketFieldVisibility;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPreviewSettingsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class TicketPreviewSettings
extends TicketListWebSocketEvent<Void> {
    public String getEventName() {
        return "ticketlist.ticketpreviewsettings";
    }

    @Override
    protected void handleEvent(String clientID, Void payload) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        String previewSettingValue = currentUserAccount == null ? null : (String)currentUserAccount.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_PREVIEWSETTING);
        String previewSettingValueDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField(TicketListServerPlugin.USERFIELD_TICKETLIST_PREVIEWSETTING);
        PreviewSettings previewSetting = new PreviewSettings();
        if (!StringFunctions.isEmpty((String)previewSettingValueDefault)) {
            previewSetting.merge((PreviewSettings)new Json().fromJson(previewSettingValueDefault, PreviewSettings.class));
        }
        if (!StringFunctions.isEmpty((String)previewSettingValue)) {
            previewSetting.merge((PreviewSettings)new Json().fromJson(previewSettingValue, PreviewSettings.class));
        }
        Comparator<TicketListColumnDescription> compareByGroupAndDisplayName = Comparator.comparing(TicketListColumnDescription::getGroupingKey).thenComparing(TicketListColumnDescription::getDisplayName, String.CASE_INSENSITIVE_ORDER);
        List<TicketListColumnDescription> allAvailableColumns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
        ArrayList<TicketFieldVisibility> hiddenTicketFields = previewSetting.getHiddenTicketFields();
        ArrayList<TicketFieldVisibility> newHiddenTicketFields = new ArrayList<TicketFieldVisibility>();
        List columnKeysTicket = allAvailableColumns.stream().sorted(compareByGroupAndDisplayName).map(TicketListColumnDescription::getKey).collect(Collectors.toList());
        for (TicketFieldVisibility hiddenField : hiddenTicketFields) {
            if (hiddenField == null || !columnKeysTicket.remove(hiddenField.getTicketFieldKey())) continue;
            newHiddenTicketFields.add(hiddenField);
        }
        for (String columnKey : columnKeysTicket) {
            newHiddenTicketFields.add(new TicketFieldVisibility(columnKey, false));
        }
        previewSetting.setHiddenTicketFields(newHiddenTicketFields);
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData(this.getEventName(), (Object)new TicketPreviewSettingsResponse(previewSetting)));
    }
}

