/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetHistoryTicketsRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetHistoryTicketsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketLink;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class GetHistoryTickets
extends AbstractTicketListHandler<GetHistoryTicketsRequest, GetHistoryTicketsResponse> {
    private static final int HISTORY_LIMIT = 5;

    public String getMethodName() {
        return "ticketlist.extension.userticketshistory.gethistorytickets";
    }

    @Override
    protected GetHistoryTicketsResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetHistoryTicketsRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        UserAccount userAccount;
        GUID ownerID;
        boolean userCanReadTicket;
        String textField = input.getTextField();
        String iconField = input.getIconField();
        String userDisplayName = null;
        String locationDisplayName = null;
        String userSearchPhrase = null;
        String locationSearchPhrase = null;
        ArrayList<TicketLink> userTickets = new ArrayList<TicketLink>();
        ArrayList<TicketLink> locationTickets = new ArrayList<TicketLink>();
        Integer ticketId = input.getTicketId();
        if (ticketId != null && !(userCanReadTicket = TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketId.intValue()))) {
            return new GetHistoryTicketsResponse(userSearchPhrase, userDisplayName, userTickets, locationSearchPhrase, locationDisplayName, locationTickets);
        }
        boolean supporter = HDUsersAndGroups.isSupporter((UserAccount)currentUser);
        List ticketFieldDefinitions = Tickets.getFieldsVisibleForUser();
        TicketFieldDefinition textFieldDefinition = ticketFieldDefinitions.stream().filter(tfd -> tfd.getKey().equals(textField)).findFirst().orElse(null);
        TicketFieldDefinition iconFieldDefinition = ticketFieldDefinitions.stream().filter(tfd -> tfd.getKey().equals(iconField)).findFirst().orElse(null);
        if (textFieldDefinition == null) {
            textFieldDefinition = ticketFieldDefinitions.stream().filter(tfd -> tfd.getKey().equals(Tickets.FIELD_SUBJECT.getKey())).findFirst().orElse(null);
        }
        if (iconFieldDefinition == null) {
            iconFieldDefinition = ticketFieldDefinitions.stream().filter(tfd -> tfd.getKey().equals(Tickets.ATTRIBUTE_STATUS_ID.getKey())).findFirst().orElse(null);
        }
        if ((ownerID = input.getTicketOwnerId()) != null && (userAccount = UserManager.getInstance().getUserAccount(ownerID)) != null) {
            LocationVO location;
            Integer locationID;
            userDisplayName = userAccount.getDisplayName();
            userSearchPhrase = Tickets.FIELD_OWNER_GUID.getSearchTag().getDisplayName() + ":\"" + ownerID.toString() + "\"";
            SearchCommand command = new SearchCommand(new SearchExpression[]{new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)ownerID.toString())});
            TreeSet<Integer> searchResult = new TreeSet<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o2.compareTo(o1);
                }
            });
            if (!supporter) {
                CustomTicketViewDefinition.addCondition_forEndUserFromTicketNumber((GUID)currentUser.getID(), (AndSearchExpression)command.getSearchExpression());
            }
            Set searchedIDs = TicketManager.getReader().getSearchEngine().simpleSearch(command);
            TicketViewManager.getInstance().convertToBunIdsIfNeeded(TicketManager.getReader().getSlaveInfoEngine(), searchedIDs, currentUser.getID());
            searchResult.addAll(searchedIDs);
            HashSet<Integer> knownIDs = new HashSet<Integer>();
            if (ticketId != null) {
                knownIDs.add(ticketId);
            }
            for (Integer tid : searchResult) {
                try {
                    Integer ticketID;
                    TicketVO ticketVO = TicketManager.getReader().getTicket(tid.intValue());
                    if (ticketVO == null || knownIDs.contains(ticketID = Integer.valueOf(ticketVO.getID()))) continue;
                    knownIDs.add(ticketID);
                    userTickets.add(new TicketLink(TicketLink.LinkGroup.free, TicketLink.LinkType.freelink, ticketVO.getID(), false, iconFieldDefinition != null ? iconFieldDefinition.getValueAsStringForIcon(ticketVO) : null, textFieldDefinition.getDisplayValue(ticketVO), null));
                    if (userTickets.size() < 5) continue;
                    break;
                }
                catch (AccessDeniedException ade) {
                }
            }
            if ((locationID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)) != null && (location = (LocationVO)LocationManager.getInstance().get(locationID.intValue())) != null) {
                locationDisplayName = location.getDisplayValue();
                locationSearchPhrase = HDUsersAndGroups.FIELD_LOCATION_ID.getSearchTag().getDisplayName() + ":\"" + locationID.toString() + "\"";
                SearchTag parentTag = TicketManager.getReader().getSearchEngine().getTag("ownerid");
                SearchTag locationTag = UserManager.getInstance().getSearchEngine().getTag("location");
                locationSearchPhrase = new JoinTokenMatcher(null, parentTag, null, locationTag, false).getDisplayName().replace(' ', '-') + ":\"" + locationDisplayName + "\"";
                Set users = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand("location", SearchCondition.SearchTermOperator.Equals, (Object)locationID));
                Set subResult = TicketManager.getReader().getSearchEngine().simpleSearch(new SearchCommand("ownerid", SearchCondition.SearchTermOperator.IN, (Object)users));
                TicketViewManager.getInstance().convertToBunIdsIfNeeded(TicketManager.getReader().getSlaveInfoEngine(), subResult, currentUser.getID());
                searchResult.clear();
                searchResult.addAll(subResult);
                for (Integer tid : searchResult) {
                    try {
                        Integer ticketID;
                        TicketVO ticketVO = TicketManager.getReader().getTicket(tid.intValue());
                        if (ticketVO == null || knownIDs.contains(ticketID = Integer.valueOf(ticketVO.getID()))) continue;
                        knownIDs.add(ticketID);
                        locationTickets.add(new TicketLink(TicketLink.LinkGroup.free, TicketLink.LinkType.freelink, ticketVO.getID(), false, iconFieldDefinition != null ? iconFieldDefinition.getValueAsStringForIcon(ticketVO) : null, textFieldDefinition.getDisplayValue(ticketVO), null));
                        if (locationTickets.size() < 5) continue;
                        break;
                    }
                    catch (AccessDeniedException ade) {
                    }
                }
            }
        }
        return new GetHistoryTicketsResponse(userSearchPhrase, userDisplayName, userTickets, locationSearchPhrase, locationDisplayName, locationTickets);
    }
}

