/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.TicketReaderBase;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionWithHyperlink;
import com.inet.helpdesk.core.ticketview.TicketListState;
import com.inet.helpdesk.core.ticketview.TicketListUpdateEvent;
import com.inet.helpdesk.core.ticketview.TicketListUpdateListener;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketValue;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.ColumnDisplayType;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketListEntry;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketListUpdateData;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketListUpdateResponse;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TicketListUpdateStart
extends TicketListWebSocketEvent<TicketListUpdateData> {
    public String getEventName() {
        return "ticketlist.ticketlistupdatestart";
    }

    @Override
    protected void handleEvent(final String clientID, final TicketListUpdateData payload) {
        if (StringFunctions.isEmpty((String)payload.getViewId())) {
            TicketViewManager.getInstance().unregisterTicketList(clientID);
            return;
        }
        TicketListUpdateListener updateListener = new TicketListUpdateListener(){

            public void ticketListChanged(TicketListUpdateEvent evt) {
                if (UserManager.getInstance().getCurrentUserAccountID() == null) {
                    return;
                }
                Supplier<WebSocketEventData> eventFactory = () -> {
                    List<TicketListColumnDescription> columnsIdentifier;
                    List<TicketListColumnDescription> columnsAdditional;
                    TicketReader ticketReader = TicketManager.getReader();
                    HashMap<String, SortGroup> sortGroups = new HashMap<String, SortGroup>();
                    List ticketFieldDefinitions = Tickets.getFieldsVisibleForUser();
                    GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
                    TicketListLayoutDescription currentLayout = TicketListLayoutManager.getInstance().getCurrentLayout(currentUserAccountID);
                    HashSet fieldKeys = new HashSet();
                    List<TicketListColumnDescription> columnsFixed = currentLayout.getFixedColumns();
                    if (columnsFixed != null) {
                        fieldKeys.addAll(columnsFixed.stream().filter(c -> c.getDisplayType() == ColumnDisplayType.visible).map(TicketListColumnDescription::getKey).collect(Collectors.toSet()));
                    }
                    if ((columnsAdditional = currentLayout.getAdditionalColumns()) != null) {
                        fieldKeys.addAll(columnsAdditional.stream().map(TicketListColumnDescription::getKey).collect(Collectors.toSet()));
                    }
                    if ((columnsIdentifier = currentLayout.getIdentifierColumns()) != null) {
                        fieldKeys.addAll(columnsIdentifier.stream().map(TicketListColumnDescription::getKey).collect(Collectors.toSet()));
                    }
                    Locale threadLocale = ClientLocale.getThreadLocale();
                    TimeZone timeZone = ClientTimezone.getTimeZone();
                    Set<TicketListEntry> ticketListEntries = evt.changedTickets.parallelStream().map(arg_0 -> 1.lambda$ticketListChanged$1(threadLocale, timeZone, currentUserAccountID, (TicketReaderBase)ticketReader, ticketFieldDefinitions, fieldKeys, arg_0)).collect(Collectors.toSet());
                    String sortedColumn = evt.state.getSortedColumn();
                    if (evt.sortGroupKeys != null && !evt.sortGroupKeys.isEmpty() && sortedColumn != null) {
                        SortGroupInformation sortGroupInformation = null;
                        for (TicketFieldDefinition fieldDefinition : ticketFieldDefinitions) {
                            if (!sortedColumn.equals(fieldDefinition.getKey()) || (sortGroupInformation = fieldDefinition.getSortGroupInformation()).supportsSortGroups()) continue;
                            sortGroupInformation = null;
                            break;
                        }
                        if (sortGroupInformation != null) {
                            for (String sortGroupKey : evt.sortGroupKeys.values()) {
                                if (sortGroups.containsKey(sortGroupKey)) continue;
                                sortGroups.put(sortGroupKey, sortGroupInformation.getSortGroupForKey(sortGroupKey));
                            }
                        }
                    }
                    TicketListUpdateResponse responseData = new TicketListUpdateResponse(evt, ticketListEntries, sortGroups);
                    return new WebSocketEventData("ticketlist.ticketlistupdatedata", (Object)responseData);
                };
                WebSocketEventHandler.getInstance().sendEvent(clientID, eventFactory);
            }

            @Nonnull
            public String getViewID() {
                return payload.getViewId();
            }

            private static /* synthetic */ TicketListEntry lambda$ticketListChanged$1(Locale threadLocale, TimeZone timeZone, GUID currentUserAccountID, TicketReaderBase ticketReader, List ticketFieldDefinitions, HashSet fieldKeys, Integer ticketId) {
                Locale oldLocale = ClientLocale.getThreadLocale();
                TimeZone oldTimezone = ClientTimezone.getTimeZone();
                ClientLocale.setThreadLocale((Locale)threadLocale);
                ClientTimezone.setTimeZone((TimeZone)timeZone);
                try {
                    TicketListEntry ticketListEntry;
                    block16: {
                        HashMap<String, TicketValue> values;
                        TicketVO ticket;
                        UserAccountScope userScope;
                        block14: {
                            TicketListEntry ticketListEntry2;
                            block15: {
                                userScope = UserAccountScope.create((GUID)currentUserAccountID);
                                ticket = null;
                                try {
                                    ticket = ticketReader.getTicket(ticketId.intValue());
                                }
                                catch (AccessDeniedException accessDeniedException) {
                                    // empty catch block
                                }
                                values = new HashMap<String, TicketValue>();
                                if (ticket != null) break block14;
                                ticketListEntry2 = new TicketListEntry(ticketId, false, values);
                                if (userScope == null) break block15;
                                userScope.close();
                            }
                            return ticketListEntry2;
                        }
                        try {
                            for (TicketFieldDefinition fieldDefinition : ticketFieldDefinitions) {
                                if (!fieldKeys.contains(fieldDefinition.getKey())) continue;
                                String displayValue = fieldDefinition.getDisplayValue(ticket);
                                String valueAsString = fieldDefinition.supportsIcon() ? fieldDefinition.getValueAsStringForIcon(ticket) : null;
                                String hyperlink = fieldDefinition instanceof TicketFieldDefinitionWithHyperlink && ((TicketFieldDefinitionWithHyperlink)fieldDefinition).isLinkField() ? ((TicketFieldDefinitionWithHyperlink)fieldDefinition).getHyperlink(ticket) : null;
                                values.put(fieldDefinition.getKey(), new TicketValue(valueAsString, displayValue, fieldDefinition.getDescription(ticket), hyperlink));
                            }
                            TicketPermissionContext permissionContext = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketId.intValue());
                            boolean unread = permissionContext.hasSupporterAccessToTicket() ? ticket.isUnreadForSupporter() : ticket.isUnreadForEnduser();
                            ticketListEntry = new TicketListEntry(ticket.getID(), unread, values);
                            if (userScope == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (userScope != null) {
                                try {
                                    userScope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        userScope.close();
                    }
                    return ticketListEntry;
                }
                finally {
                    ClientLocale.setThreadLocale((Locale)oldLocale);
                    ClientTimezone.setTimeZone((TimeZone)oldTimezone);
                }
            }
        };
        TicketListState state = new TicketListState(payload.getPhrase(), payload.getWindowSize(), payload.getSortedColumn(), payload.isSortedAscending());
        TicketViewManager.getInstance().registerTicketList(clientID, updateListener, state);
        if (!"globalticketsearch".equals(payload.getViewId())) {
            UserManager userManager = UserManager.getInstance();
            MutableUserData userData = new MutableUserData();
            userData.put(TicketListServerPlugin.USERFIELD_TICKETLIST_LASTVIEW, (Object)payload.getViewId());
            userManager.updateUserData(userManager.getCurrentUserAccountID(), userData);
        }
    }
}

