/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketListApplyActionData;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.helpdesk.plugins.ticketlist.server.ticketupdate.TicketUpdateDispatcher;
import com.inet.helpdesk.plugins.ticketlist.server.ticketupdate.TicketUpdateListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TicketListApplyActionStart
extends TicketListWebSocketEvent<TicketListApplyActionData>
implements TicketUpdateListener {
    public String getEventName() {
        return "ticketlist.applyactionstart";
    }

    @Override
    protected void handleEvent(String clientID, TicketListApplyActionData payload) {
        TicketUpdateDispatcher.getInstance().remove("applyaction", clientID);
        List<Integer> tIDs = payload.getTicketIds();
        if (tIDs != null) {
            for (Integer ticketID : tIDs) {
                TicketUpdateDispatcher.getInstance().put("applyaction", clientID, UserManager.getInstance().getCurrentUserAccountID(), ticketID, this);
            }
            TicketReader ticketReader = TicketManager.getReader();
            HashSet<ActionVO> actions = null;
            for (Integer ticketID : tIDs) {
                TicketVO ticket = ticketReader.getTicket(ticketID.intValue());
                if (ticket == null) {
                    WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.applyaction", (Object)Collections.EMPTY_LIST));
                    return;
                }
                if (actions == null) {
                    actions = new HashSet<ActionVO>();
                    allPossibleActions = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticket.getID());
                    if (allPossibleActions != null) {
                        actions.addAll(allPossibleActions);
                    }
                } else {
                    allPossibleActions = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticket.getID());
                    actions.removeIf(a -> !allPossibleActions.contains(a));
                }
                if (!actions.isEmpty()) continue;
                WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.applyaction", (Object)Collections.EMPTY_LIST));
                return;
            }
            if (actions != null) {
                actions.removeIf(a -> a.getId() == -7 || 211 == a.getStatusID());
            }
            List<ActionDescription> convertTicketActions = TicketFunctions.convertTicketActions((Collection<ActionVO>)actions, TicketListServerPlugin.USERFIELD_TICKETLIST_ACTIONCOUNT_MULTIEDIT);
            WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.applyaction", (Object)convertTicketActions));
        } else {
            WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.applyaction", (Object)Collections.EMPTY_LIST));
        }
    }

    @Override
    public void ticketChanged(String clientID, TicketVO ticket, Set<Integer> stepIds) {
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData(this.getEventName(), null));
    }
}

