/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.ticketlist.api.TicketListLayout;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.ColumnDisplayType;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutSpecificSettingsModel;
import com.inet.lib.util.StringFunctions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
public class TicketListLayoutDescription {
    private String layoutKey;
    private String description;
    private String displayName;
    private int ticketListBlockSize;
    private List<TicketListColumnDescription> fixedColumns;
    private Map<String, ColumnDisplayType> fixedColumnsDisplayTypes;
    private List<String> mandatoryColumnKeys;
    private List<TicketListColumnDescription> additionalColumns;
    private int maximumAdditionalColumnCount;
    private int minimumAdditionalColumnCount;
    private List<TicketListColumnDescription> identifierColumns;
    private int maximumIdentifierColumnCount;
    private String previewLayout;
    private boolean grouping;
    private String identifierColumnWidth;
    private boolean hasWidthsSet;

    private TicketListLayoutDescription() {
    }

    public String getLayoutKey() {
        return this.layoutKey;
    }

    public String getPreviewLayout() {
        return this.previewLayout;
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    public String getIdentifierColumnWidth() {
        return this.identifierColumnWidth;
    }

    public List<TicketListColumnDescription> getFixedColumns() {
        return this.fixedColumns;
    }

    public List<TicketListColumnDescription> getAdditionalColumns() {
        return this.additionalColumns;
    }

    public List<TicketListColumnDescription> getIdentifierColumns() {
        return this.identifierColumns;
    }

    public static TicketListLayoutDescription fromTicketListLayout(TicketListLayout ticketListLayout, TicketListLayoutSpecificSettingsModel layoutSpecificSettings) {
        Map<String, TicketListColumnDescription> allAvailableColumns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false).stream().collect(Collectors.toMap(TicketListColumnDescription::getKey, tlcd -> tlcd));
        TicketListLayoutDescription descr = new TicketListLayoutDescription();
        descr.layoutKey = ticketListLayout.getKey();
        descr.description = ticketListLayout.getDescription();
        descr.displayName = ticketListLayout.getDisplayName();
        descr.ticketListBlockSize = ticketListLayout.getTicketListBlockSize();
        descr.fixedColumns = ticketListLayout.getFixedColumns(allAvailableColumns, layoutSpecificSettings);
        descr.fixedColumnsDisplayTypes = descr.fixedColumns.stream().collect(Collectors.toMap(TicketListColumnDescription::getKey, TicketListColumnDescription::getDisplayType));
        descr.additionalColumns = ticketListLayout.getAdditionalColumns(allAvailableColumns, layoutSpecificSettings);
        descr.maximumAdditionalColumnCount = ticketListLayout.getMaximumAdditionalColumnCount();
        descr.minimumAdditionalColumnCount = ticketListLayout.getMinimumAdditionalColumnCount();
        descr.identifierColumns = ticketListLayout.getIdentifierColumns(allAvailableColumns, layoutSpecificSettings);
        descr.maximumIdentifierColumnCount = ticketListLayout.getMaximumIdentifierColumnCount();
        String previewLayout = null;
        if (layoutSpecificSettings != null && (previewLayout = layoutSpecificSettings.getPreviewLayout()) != null) {
            try {
                TicketListLayout.PreviewPosition.valueOf(previewLayout);
            }
            catch (IllegalArgumentException iae) {
                previewLayout = null;
            }
        }
        if (previewLayout == null) {
            previewLayout = ticketListLayout.getDefaultPreviewPosition().name();
        }
        descr.previewLayout = previewLayout;
        boolean grouping = true;
        if (layoutSpecificSettings != null) {
            grouping = layoutSpecificSettings.isGrouping();
        }
        descr.grouping = grouping;
        if (layoutSpecificSettings != null) {
            descr.identifierColumnWidth = layoutSpecificSettings.getIdentifierColumnWidth();
        }
        boolean hasWidthsSet = false;
        if (!StringFunctions.isEmpty((String)descr.identifierColumnWidth)) {
            hasWidthsSet = true;
        } else if (descr.fixedColumns != null && descr.fixedColumns.stream().anyMatch(c -> !StringFunctions.isEmpty((String)c.getWidth()))) {
            hasWidthsSet = true;
        } else if (descr.additionalColumns != null && descr.additionalColumns.stream().anyMatch(c -> !StringFunctions.isEmpty((String)c.getWidth()))) {
            hasWidthsSet = true;
        }
        descr.hasWidthsSet = hasWidthsSet;
        return descr;
    }
}

