/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ticketpageextensions.timeline;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimelineExtension
implements TicketPageExtension {
    public static final String EXTENSION_KEY = "timeline";

    @Nonnull
    public String getExtensionName() {
        return EXTENSION_KEY;
    }

    public String getDisplayName() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.timeline.displayname", new Object[0]);
    }

    public String getDescription() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.timeline.description", new Object[0]);
    }

    public URL getTemplateURL() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketpage/extensions/timelineextension.html");
    }

    public boolean isDefaultVisible() {
        return true;
    }

    public boolean isVisibleForTicket(int ticketID) {
        return true;
    }

    public boolean isAvailable(UserAccount userAccount) {
        return true;
    }

    @Nullable
    public String getCountPreview(UserAccount userAccount, TicketVO ticket) {
        boolean isSupporter = userAccount != null && HDUsersAndGroups.isSupporter((UserAccount)userAccount);
        return "" + TicketManager.getReader().getReaStepsForTicket(ticket.getID(), isSupporter ? BundleStepsFilter.WITH_BUNDLE_STEPS : BundleStepsFilter.WITHOUT_BUNDLE_STEPS).size();
    }
}

