/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.config.ConfigValue;
import com.inet.error.BaseErrorCode;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSlaveForEnduser;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionWithHyperlink;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageHint;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.TicketAttachmentsContextDependentLoader;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.plugins.ticketlist.api.data.StepDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketValue;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.AdditionalAccess;
import com.inet.helpdesk.plugins.ticketlist.server.data.StopWatchDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageDetails;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageExtensionDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageUpdateData;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketViewer;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.ticketupdate.TicketUpdateDispatcher;
import com.inet.helpdesk.plugins.ticketlist.server.ticketupdate.TicketUpdateListener;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TicketPageUpdateStart
extends TicketListWebSocketEvent<TicketPageUpdateData>
implements TicketUpdateListener {
    private TicketAccessInformationsProvider.TicketAccessChangedListener ticketAccessListener;
    public static final ConfigValue<Integer> CONTENT_CHANGEABLE = new ConfigValue(HDConfigKeys.PROCESSING_CONTENT_CHANGEABLE_WHEN_CLOSED);
    public static final ConfigValue<Boolean> EFFORT_CHANGEABLE = new ConfigValue(HDConfigKeys.CLIENT_EFFORTTIME_CHANGE);

    public TicketPageUpdateStart() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String clientID) {
            }

            public void connectionClosed(String clientID) {
                ((TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class)).leaveAllTickets(clientID);
            }
        });
    }

    private synchronized void init() {
        if (this.ticketAccessListener != null) {
            return;
        }
        this.ticketAccessListener = new TicketAccessInformationsProvider.TicketAccessChangedListener(){

            public void ticketAccessChanged(TicketAccessInformationsProvider.TicketAccessChangedEvent changedTicket) {
                TicketAccessInfo newAccessInfo = changedTicket.getNewAccessInfo();
                if (newAccessInfo == null) {
                    return;
                }
                this.viewersChanged(newAccessInfo, changedTicket.getTicketId());
            }

            private void viewersChanged(TicketAccessInfo ticketAccessInfo, int ticketId) {
                if (ticketAccessInfo != null) {
                    ArrayList<TicketViewer> viewer = new ArrayList<TicketViewer>();
                    ArrayList<String> clientIDs = new ArrayList<String>();
                    TicketAccessInfo.TicketAccessor writeSession = ticketAccessInfo.getWriteSession();
                    List readSessions = ticketAccessInfo.getReadSessions();
                    if (writeSession != null) {
                        viewer.add(new TicketViewer(writeSession.getUser(), writeSession.getClientID(), true));
                        clientIDs.add(writeSession.getClientID());
                    }
                    if (readSessions != null) {
                        for (TicketAccessInfo.TicketAccessor accessor : readSessions) {
                            viewer.add(new TicketViewer(accessor.getUser(), accessor.getClientID(), false));
                            clientIDs.add(accessor.getClientID());
                        }
                    }
                    for (String clientID : clientIDs) {
                        if (clientID == null) continue;
                        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.ticketpageviewers", (Object)viewer));
                    }
                }
            }

            public void ticketStopWatchChanged(TicketAccessInformationsProvider.TicketStopWatchChangedEvent event) {
                Set<String> clientsforTicketAndUser = TicketUpdateDispatcher.getInstance().getClientsforTicketAndUser("ticketpage", event.getTicketId(), event.getUserId());
                StopWatchDescription stopWatchDescription = StopWatchDescription.from(event.getStopWatch());
                for (String clientID : clientsforTicketAndUser) {
                    if (clientID == null) continue;
                    WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.ticketpagestopwatch", (Object)stopWatchDescription));
                }
            }
        };
        ((TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class)).addTicketAccessChangedListener(this.ticketAccessListener);
    }

    public String getEventName() {
        return "ticketlist.ticketpageupdatestart";
    }

    @Override
    protected void handleEvent(String clientID, TicketPageUpdateData payload) {
        this.init();
        TicketUpdateDispatcher.getInstance().remove("ticketpage", clientID);
        Integer tID = payload.getTicketID();
        if (tID != null) {
            TicketVO ticket;
            int ticketID;
            block5: {
                ticketID = tID;
                TicketReader ticketReader = TicketManager.getReader();
                ticket = null;
                try {
                    ticket = ticketReader.getTicket(ticketID);
                }
                catch (AccessDeniedException ade) {
                    if (ade.getErrorCode() == BaseErrorCode.forbidden.getErrorCodeNumber()) break block5;
                    throw ade;
                }
            }
            if (ticket != null) {
                ((TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class)).accessTicketRead(clientID, ticketID);
            }
            this.ticketChanged(clientID, ticket, null);
            TicketUpdateDispatcher.getInstance().put("ticketpage", clientID, UserManager.getInstance().getCurrentUserAccountID(), ticketID, this);
        } else {
            ((TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class)).leaveAllTickets(clientID);
        }
    }

    @Override
    public void ticketChanged(String clientID, TicketVO ticketArg, Set<Integer> changedStepIds) {
        if (ticketArg == null || !TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketArg.getID())) {
            WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.ticketpageupdate", null));
            ((TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class)).leaveAllTickets(clientID);
            return;
        }
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> {
            boolean stopWatchAvailable;
            HashSet hiddenHintsSet;
            String hiddenHintsValue;
            List allTicketsInBundle;
            boolean isSupporter;
            TicketVO ticket = ticketArg;
            UserManager userManager = UserManager.getInstance();
            UserAccount currentUserAccount = userManager.getCurrentUserAccount();
            boolean bl = isSupporter = currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
            if (isSupporter && ticket instanceof TicketVOSlaveForEnduser) {
                ticket = TicketManager.getReader().getTicket(ticket.getID());
            }
            HashMap<String, TicketValue> ticketDetails = new HashMap<String, TicketValue>();
            List ticketFieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            List<TicketListColumnDescription> columns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
            HashSet fieldKeys = new HashSet();
            fieldKeys.addAll(columns.stream().map(TicketListColumnDescription::getKey).collect(Collectors.toSet()));
            for (TicketFieldDefinition fieldDefinition : ticketFieldDefinitions) {
                String hyperlink;
                if (!fieldKeys.contains(fieldDefinition.getKey())) continue;
                String displayValue = fieldDefinition.getDisplayValue(ticket);
                String valueAsString = fieldDefinition.supportsIcon() ? fieldDefinition.getValueAsStringForIcon(ticket) : null;
                String string = hyperlink = fieldDefinition instanceof TicketFieldDefinitionWithHyperlink && ((TicketFieldDefinitionWithHyperlink)fieldDefinition).isLinkField() ? ((TicketFieldDefinitionWithHyperlink)fieldDefinition).getHyperlink(ticket) : null;
                if (StringFunctions.isEmpty((String)displayValue) && StringFunctions.isEmpty((String)valueAsString) && StringFunctions.isEmpty((String)hyperlink)) continue;
                ticketDetails.put(fieldDefinition.getKey(), new TicketValue(valueAsString, displayValue, fieldDefinition.getDescription(ticket), hyperlink));
            }
            HashSet<GUID> ticketOwnerIds = new HashSet<GUID>();
            ticketOwnerIds.add(ticket.getOwnerID());
            TicketReader ticketReader = TicketManager.getReader();
            List reaStepVOs = ticketReader.getReaStepsForTicket(ticket.getID(), isSupporter ? BundleStepsFilter.WITH_BUNDLE_STEPS : BundleStepsFilter.WITHOUT_BUNDLE_STEPS);
            ArrayList<StepDescription> changedSteps = new ArrayList<StepDescription>();
            if (ticket.isMasterInBundle() && isSupporter && (allTicketsInBundle = ticketReader.getTicketsInBundle(ticket.getID(), false)) != null) {
                for (TicketVOSingle bundledTicket : allTicketsInBundle) {
                    ticketOwnerIds.add(bundledTicket.getOwnerID());
                }
            }
            HashSet<@Nonnull Integer> availableStepsIds = new HashSet<Integer>();
            for (ReaStepVO step : reaStepVOs) {
                availableStepsIds.add(step.getID());
            }
            HashSet stepsWithAttachments = new HashSet();
            ArrayList<SavedAttachmentData> attachments = new ArrayList();
            ServerPluginManager spm = ServerPluginManager.getInstance();
            if (spm.isPluginLoaded("attachments")) {
                TicketAttachmentsContextDependentLoader.TicketAttachmentsContextDependentLoaderResult result = new TicketAttachmentsContextDependentLoader().load(ticket, availableStepsIds);
                stepsWithAttachments = result.getStepsWithAttachments();
                attachments = result.getAttachments().stream().map(a -> new SavedAttachmentData(a.getOwnerId(), a.getStepId(), a.getAdditionalId(), a.getTypeId(), a.getFileName(), a.getMimeType(), a.getFileLength(), a.getLastModified(), a.isEmbedded(), a.isDuplicate())).collect(Collectors.toList());
            }
            for (ReaStepVO step : reaStepVOs) {
                UserAccount userAccount;
                boolean newOrAdded;
                boolean bl2 = newOrAdded = changedStepIds == null || changedStepIds.contains(step.getID());
                if (!newOrAdded) continue;
                StepDescription stepDescription = TicketFunctions.convertToStepDescription(step, availableStepsIds);
                stepDescription.setFromTicketOwner(step.getUserID() != null && ticketOwnerIds.contains(step.getUserID()));
                boolean isFromSupporter = false;
                if (step.getUserID() != null && (userAccount = userManager.getUserAccount(step.getUserID())) != null) {
                    isFromSupporter = HDUsersAndGroups.isSupporter((UserAccount)userAccount);
                }
                stepDescription.setFromSupporter(isFromSupporter);
                if (!stepDescription.isConversationStep() && stepsWithAttachments.contains(stepDescription.getId())) {
                    stepDescription.setConversationStep(true);
                }
                changedSteps.add(stepDescription);
            }
            HashSet<Integer> deletedSteps = new HashSet<Integer>();
            if (changedStepIds != null) {
                deletedSteps.addAll(changedStepIds);
                deletedSteps.removeIf(stepId -> availableStepsIds.contains(stepId));
            }
            List allPossibleActions = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticket.getID());
            List<ActionDescription> editActions = TicketFunctions.convertTicketActions(allPossibleActions, TicketListServerPlugin.USERFIELD_TICKETLIST_ACTIONCOUNT);
            List<Integer> allPossibleActionIds = allPossibleActions.stream().map(FieldVO::getId).collect(Collectors.toList());
            boolean isPartOfBundle = ticket.isMasterInBundle() || ticket.isSlaveInBundle();
            Set linkedTickets = ticket.getLinkedTickets();
            int freeLinkCount = linkedTickets.size();
            ItilLinkManager itilManager = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
            freeLinkCount += itilManager.getItilLinkCount(ticket.getID());
            ArrayList<TicketViewer> viewer = new ArrayList<TicketViewer>();
            TicketAccessInformationsProvider ticketAccessInformationsProvider = (TicketAccessInformationsProvider)spm.getSingleInstance(TicketAccessInformationsProvider.class);
            TicketAccessInfo ticketAccessInfo = ticketAccessInformationsProvider.getTicketAccessInfo(ticket.getID());
            if (ticketAccessInfo != null) {
                TicketAccessInfo.TicketAccessor writeSession = ticketAccessInfo.getWriteSession();
                List readSessions = ticketAccessInfo.getReadSessions();
                if (writeSession != null) {
                    viewer.add(new TicketViewer(writeSession.getUser(), writeSession.getClientID(), true));
                }
                if (readSessions != null) {
                    for (TicketAccessInfo.TicketAccessor accessor : readSessions) {
                        viewer.add(new TicketViewer(accessor.getUser(), accessor.getClientID(), false));
                    }
                }
            }
            boolean isWritable = TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticket.getID());
            TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID());
            boolean hasSupporterWritePermission = ticketPermissionInfo.hasSupporterWriteAccessToTicket();
            boolean isOpenTicket = Status.isOpenStatus((int)ticket.getStatusID());
            boolean canSetUnread = ticketPermissionInfo.hasSupporterWriteAccessToTicket() || ticketPermissionInfo.hasEnduserAccessToTicket();
            HashSet<@Nonnull Integer> unreadSteps = (HashSet<Integer>)ticket.getAttribute((TicketAttribute)(ticketPermissionInfo.hasSupporterAccessToTicket() ? Tickets.ATTRIBUTE_UNREAD_SUPPORTER : Tickets.ATTRIBUTE_UNREAD_ENDUSER));
            if (unreadSteps == null) {
                unreadSteps = new HashSet<Integer>();
            }
            unreadSteps.retainAll(availableStepsIds);
            TicketPageLayoutDescription currentLayout = currentUserAccount == null ? null : TicketPageLayoutManager.getInstance().getCurrentLayout(currentUserAccount.getID());
            Set visibleExtensions = currentLayout == null ? Collections.emptySet() : currentLayout.getExtensions().stream().map(TicketPageExtensionDescription::getId).collect(Collectors.toSet());
            HashSet hiddenHints = new HashSet();
            String string = hiddenHintsValue = currentUserAccount == null ? null : (String)currentUserAccount.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_HIDDEN_TICKETPAGEHINTS);
            if (!StringFunctions.isEmpty((String)hiddenHintsValue) && (hiddenHintsSet = (HashSet)new Json().fromJson(hiddenHintsValue, (Type)new JsonParameterizedType(HashSet.class, new Type[]{String.class}))) != null) {
                hiddenHints.addAll(hiddenHintsSet);
            }
            List<TicketPageExtension> extensions = ServerPluginManager.getInstance().get(TicketPageExtension.class);
            TicketVO finalTicket = ticket;
            extensions = extensions.stream().filter(e -> e.isAvailable(currentUserAccount) && e.isVisibleForTicket(finalTicket.getID())).collect(Collectors.toList());
            List<String> visibleExtensionIds = extensions.stream().map(NamedExtension::getExtensionName).collect(Collectors.toList());
            HashMap<String, String> extensionPreviews = new HashMap<String, String>();
            ArrayList<TicketPageHint> hints = new ArrayList<TicketPageHint>();
            extensions.forEach(e -> {
                if (visibleExtensions.contains(e.getExtensionName())) {
                    String preview = e.getCountPreview(currentUserAccount, finalTicket);
                    if (preview != null) {
                        extensionPreviews.put(e.getExtensionName(), preview);
                    }
                    return;
                }
                TicketPageHint hint = e.getHint(currentUserAccount, finalTicket);
                if (hint != null && !hiddenHints.contains(hint.getKey())) {
                    hints.add(hint);
                }
            });
            TicketAdditionalAccessValue ticketAdditionalAccess = (TicketAdditionalAccessValue)ticket.getValue((TicketField)Tickets.FIELD_ADDITIONAL_ACCESS);
            ArrayList<AdditionalAccess.AdditionalAccessEntry> groupsWithAccess = new ArrayList<AdditionalAccess.AdditionalAccessEntry>();
            ArrayList<AdditionalAccess.AdditionalAccessEntry> usersWithAccess = new ArrayList<AdditionalAccess.AdditionalAccessEntry>();
            if (ticketAdditionalAccess != null) {
                ticketAdditionalAccess.getWriteAccess().stream().forEach(wa -> {
                    UserAccount user;
                    UserGroupInfo group;
                    GUID id = wa.getId();
                    if (com.inet.usersandgroups.api.ui.Type.group.equals((Object)wa.getType()) && (group = UserGroupManager.getInstance().getGroup(id)) != null) {
                        groupsWithAccess.add(new AdditionalAccess.AdditionalAccessEntry(id, HDUsersAndGroups.getResourceFullDisplayName((UserGroupInfo)group), true));
                    }
                    if (com.inet.usersandgroups.api.ui.Type.user.equals((Object)wa.getType()) && (user = UserManager.getInstance().getUserAccount(id)) != null) {
                        usersWithAccess.add(new AdditionalAccess.AdditionalAccessEntry(id, user.getDisplayName(), true));
                    }
                });
                ticketAdditionalAccess.getReadAccess().stream().forEach(wa -> {
                    UserAccount user;
                    UserGroupInfo group;
                    GUID id = wa.getId();
                    if (com.inet.usersandgroups.api.ui.Type.group.equals((Object)wa.getType()) && (group = UserGroupManager.getInstance().getGroup(id)) != null) {
                        groupsWithAccess.add(new AdditionalAccess.AdditionalAccessEntry(id, HDUsersAndGroups.getResourceFullDisplayName((UserGroupInfo)group), false));
                    }
                    if (com.inet.usersandgroups.api.ui.Type.user.equals((Object)wa.getType()) && (user = UserManager.getInstance().getUserAccount(id)) != null) {
                        usersWithAccess.add(new AdditionalAccess.AdditionalAccessEntry(id, user.getDisplayName(), false));
                    }
                });
            }
            AdditionalAccess additionalAccess = new AdditionalAccess(groupsWithAccess, usersWithAccess);
            boolean bl3 = stopWatchAvailable = currentUserAccount != null && TicketAccessInformationsProvider.stopWatchIsActiveFor((UserAccount)currentUserAccount, (int)ticket.getID());
            if (stopWatchAvailable) {
                StopWatchDescription stopWatchDescription = StopWatchDescription.from(((TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class)).getStopWatchInfo(ticket.getID(), clientID));
                WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.ticketpagestopwatch", (Object)stopWatchDescription));
            }
            HashSet<@Nonnull Integer> unreadStepsCopy = unreadSteps;
            availableStepsIds.removeIf(id -> unreadStepsCopy.contains(id));
            canSetUnread = canSetUnread && availableStepsIds.size() > 0;
            boolean canEditProperties = isOpenTicket || Status.isClosedStatus((int)ticket.getStatusID()) && (Integer)CONTENT_CHANGEABLE.get() == 2;
            boolean canChangeEffort = isSupporter && (Boolean)EFFORT_CHANGEABLE.get() != false && (isOpenTicket || Status.isClosedStatus((int)ticket.getStatusID()) && (Integer)CONTENT_CHANGEABLE.get() == 2);
            return new WebSocketEventData("ticketlist.ticketpageupdate", (Object)new TicketPageDetails(isSupporter, isWritable, hasSupporterWritePermission, isOpenTicket, canEditProperties, canChangeEffort, canSetUnread, isPartOfBundle, freeLinkCount, columns, ticketDetails, unreadSteps, changedSteps, deletedSteps, attachments, allPossibleActionIds, editActions, viewer, additionalAccess, hints, extensionPreviews, visibleExtensionIds, stopWatchAvailable));
        });
    }
}

