/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.ticketlist.server.data.SearchLinkableTicketsRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.SearchLinkableTicketsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.shared.model.SuggestedEntry;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValue;
import com.inet.search.SuggestedValuesFilter;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class SearchLinkableTickets
extends AbstractTicketListHandler<SearchLinkableTicketsRequest, SearchLinkableTicketsResponse> {
    public String getMethodName() {
        return "ticketlist.extension.links.searchlinkabletickets";
    }

    @Override
    protected SearchLinkableTicketsResponse handleRequest(HttpServletRequest request, HttpServletResponse response, SearchLinkableTicketsRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        ArrayList<SearchLinkableTicketsRequest.LinkableTicket> linkableTickets = new ArrayList<SearchLinkableTicketsRequest.LinkableTicket>();
        ArrayList<SuggestedEntry> values = new ArrayList<SuggestedEntry>();
        TicketReader reader = TicketManager.getReader();
        final IndexSearchEngine searchEngine = reader.getSearchEngine();
        if (!StringFunctions.isEmpty((String)input.getTerm())) {
            Pattern pattern;
            Matcher matcher;
            Object term = input.getTerm();
            if (((String)term).contains("/ticketlist/") && ((String)term).contains("/ticket/") && (matcher = (pattern = Pattern.compile("/ticket/(\\d+)")).matcher((CharSequence)term)).find()) {
                int id2 = Integer.parseInt(matcher.group(1));
                SearchTag idTag = searchEngine.getTag("ticketid");
                if (idTag != null) {
                    String idTagDisplay = idTag.getDisplayName().replace(' ', '-');
                    term = idTagDisplay + ": " + id2;
                }
            }
            SearchCommand command = new TextSearchCommandBuilder(searchEngine, (String)term).build(ClientLocale.getThreadLocale());
            SearchExpression globalSearchExpressionForAllVisibleTickets = reader.getGlobalSearchExpressionForAllVisibleTickets(currentUser.getID(), ClientLocale.getThreadLocale());
            if (globalSearchExpressionForAllVisibleTickets != null) {
                command.getSearchExpression().add(globalSearchExpressionForAllVisibleTickets);
            }
            final Set ticketIds = searchEngine.simpleSearch(command);
            ticketIds.remove(input.getCurrentTicketId());
            ActionVO linkAction = (ActionVO)ActionManager.getInstance().get(-35);
            Iterator idsIterator = searchEngine.createIdsIterator(Tickets.ATTRIBUTE_LAST_CHANGED.getSearchTag(), false, id -> ticketIds.contains(id));
            while (idsIterator.hasNext() && linkableTickets.size() < 25) {
                TicketVO ticket = reader.getTicket(((Integer)idsIterator.next()).intValue());
                if (ticket == null) continue;
                boolean linkAddPossible = true;
                if (linkAction == null || !TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticket.getID()) || TicketManager.getTicketActionChecker().checkAction(linkAction, ticket.getID()) != null) {
                    linkAddPossible = false;
                }
                linkableTickets.add(new SearchLinkableTicketsRequest.LinkableTicket(ticket.getID(), ticket.getStatusID(), ticket.getSubject(), linkAddPossible));
            }
            SuggestedValuesFilter<Integer> filter = new SuggestedValuesFilter<Integer>(){

                public Collection<SearchTag> getSearchTags() {
                    return super.getSearchTags();
                }

                @Nonnull
                public Predicate<Integer> getCondition() {
                    return new Predicate<Integer>(){
                        private Set<Integer> allowedTickets;
                        {
                            this.allowedTickets = new HashSet<Integer>(ticketIds);
                        }

                        @Override
                        public boolean test(Integer t) {
                            if (this.allowedTickets == null) {
                                SearchCommand command = new SearchCommand(new SearchExpression[0]);
                                this.allowedTickets = searchEngine.simpleSearch(command);
                            }
                            return this.allowedTickets.contains(t);
                        }
                    };
                }
            };
            List suggestedValues = searchEngine.getSuggestedValues(input.getTerm(), (SuggestedValuesFilter)filter);
            for (SuggestedValue value : suggestedValues) {
                values.add(new SuggestedEntry(value));
            }
        }
        return new SearchLinkableTicketsResponse(linkableTickets, values);
    }
}

