/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionWithHyperlink;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.StepDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketValue;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPreviewDetails;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPreviewUpdateData;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.helpdesk.plugins.ticketlist.server.ticketupdate.TicketUpdateDispatcher;
import com.inet.helpdesk.plugins.ticketlist.server.ticketupdate.TicketUpdateListener;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TicketPreviewUpdateStart
extends TicketListWebSocketEvent<TicketPreviewUpdateData>
implements TicketUpdateListener {
    public String getEventName() {
        return "ticketlist.ticketpreviewupdatestart";
    }

    @Override
    protected void handleEvent(String clientID, TicketPreviewUpdateData payload) {
        TicketUpdateDispatcher.getInstance().remove("preview", clientID);
        Integer ticketID = payload.getTicketID();
        if (ticketID != null) {
            TicketUpdateDispatcher.getInstance().put("preview", clientID, UserManager.getInstance().getCurrentUserAccountID(), ticketID, this);
            TicketReader ticketReader = TicketManager.getReader();
            TicketVO ticket = ticketReader.getTicket(ticketID.intValue());
            if (ticket != null) {
                this.ticketChanged(clientID, ticket, null);
            }
        }
    }

    @Override
    public void ticketChanged(String clientID, TicketVO ticket, Set<Integer> stepIds) {
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> {
            HashMap<String, TicketValue> ticketDetails = new HashMap<String, TicketValue>();
            List ticketFieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            List<TicketListColumnDescription> columns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
            ArrayList<StepDescription> lastSteps = new ArrayList<StepDescription>();
            HashSet fieldKeys = new HashSet();
            fieldKeys.addAll(columns.stream().map(TicketListColumnDescription::getKey).collect(Collectors.toSet()));
            if (ticket != null) {
                ReaStepVO step;
                StepDescription stepDescription;
                for (TicketFieldDefinition fieldDefinition : ticketFieldDefinitions) {
                    String hyperlink;
                    if (!fieldKeys.contains(fieldDefinition.getKey())) continue;
                    String displayValue = fieldDefinition.getDisplayValue(ticket);
                    String valueAsString = fieldDefinition.supportsIcon() ? fieldDefinition.getValueAsStringForIcon(ticket) : null;
                    String string = hyperlink = fieldDefinition instanceof TicketFieldDefinitionWithHyperlink && ((TicketFieldDefinitionWithHyperlink)fieldDefinition).isLinkField() ? ((TicketFieldDefinitionWithHyperlink)fieldDefinition).getHyperlink(ticket) : null;
                    if (StringFunctions.isEmpty((String)displayValue) && StringFunctions.isEmpty((String)valueAsString) && StringFunctions.isEmpty((String)hyperlink)) continue;
                    ticketDetails.put(fieldDefinition.getKey(), new TicketValue(valueAsString, displayValue, fieldDefinition.getDescription(ticket), hyperlink));
                }
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                boolean isSupporter = currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
                TicketReader ticketReader = TicketManager.getReader();
                List reaSteps = ticketReader.getReaStepsForTicket(ticket.getID(), isSupporter ? BundleStepsFilter.WITH_BUNDLE_STEPS : BundleStepsFilter.WITHOUT_BUNDLE_STEPS);
                Iterator iterator = reaSteps.iterator();
                while (iterator.hasNext() && !(stepDescription = TicketFunctions.convertToStepDescription(step = (ReaStepVO)iterator.next(), Collections.emptySet())).isConversationStep() && lastSteps.size() < 10) {
                    lastSteps.add(stepDescription);
                }
            }
            return new WebSocketEventData("ticketlist.ticketpreviewupdate", (Object)new TicketPreviewDetails(columns, ticketDetails, lastSteps));
        });
    }
}

