/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ticketpageextensions.usertickethistory;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageHint;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.user.UserAccount;
import java.net.URL;
import java.util.Set;
import javax.annotation.Nonnull;

public class UserTicketHistoryExtension
implements TicketPageExtension {
    public static final String EXTENSION_KEY = "userticketshistory";

    @Nonnull
    public String getExtensionName() {
        return EXTENSION_KEY;
    }

    public String getDisplayName() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.userticketshistory.displayname", new Object[0]);
    }

    public String getDescription() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.userticketshistory.description", new Object[0]);
    }

    public URL getTemplateURL() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketpage/extensions/userticketshistoryextension.html");
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public boolean isAvailable(UserAccount userAccount) {
        return HDUsersAndGroups.isSupporter((UserAccount)userAccount);
    }

    public boolean isVisibleForTicket(int ticketID) {
        return !TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketID).hasEnduserAccessToTicket();
    }

    public TicketPageHint getHint(UserAccount userAccount, TicketVO ticket) {
        GUID ownerID;
        if (ticket != null && (ownerID = ticket.getOwnerID()) != null) {
            SearchCommand command = new SearchCommand(new SearchExpression[]{new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)ownerID.toString())});
            command.setResultLimit(10);
            Set searchedIDs = TicketManager.getReader().getSearchEngine().simpleSearch(command);
            TicketViewManager.getInstance().convertToBunIdsIfNeeded(TicketManager.getReader().getSlaveInfoEngine(), searchedIDs, userAccount.getID());
            for (Integer tId : searchedIDs) {
                if (ticket.getID() == tId.intValue() || !TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(tId.intValue())) continue;
                return new TicketPageHint(EXTENSION_KEY, this.getDisplayName(), "userticketshistory.ownerhasmoretickets", TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.userticketshistory.hint.ownerhasmoretickets.title", new Object[0]), TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.userticketshistory.hint.ownerhasmoretickets.message", new Object[0]));
            }
        }
        return null;
    }
}

