/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;

@JsonData
public class PriorityDescription {
    private String displayValue;
    private String colorAsHex;

    public static PriorityDescription create(PriorityVO prioVO, long minPrio, long maxPrio) {
        PriorityDescription prio = new PriorityDescription();
        prio.displayValue = prioVO.getDisplayValue();
        prio.colorAsHex = PriorityDescription.calculatePrioColor(prioVO.getId(), minPrio, maxPrio);
        return prio;
    }

    private static String calculatePrioColor(long value, long minPrio, long maxPrio) {
        int rgb = PriorityManager.getPrioColor((long)value, (long)minPrio, (long)maxPrio);
        Object hex = Integer.toHexString(rgb & 0xFFFFFF);
        while (((String)hex).length() < 6) {
            hex = "0" + (String)hex;
        }
        hex = "#" + (String)hex;
        return hex;
    }
}

