/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketFieldVisibility;
import java.util.ArrayList;

@JsonData
public class NewTicketDialogSettings {
    private ArrayList<TicketFieldVisibility> hiddenTicketFields;
    private boolean suggestKbArticles = true;

    private NewTicketDialogSettings() {
    }

    public NewTicketDialogSettings(boolean isSupporter) {
        this.hiddenTicketFields = isSupporter ? new ArrayList<TicketFieldVisibility>(){
            {
                this.add(new TicketFieldVisibility(Tickets.FIELD_RESOURCE_GUID.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_PRIORITY_ID.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_CATEGORY_ID.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_DEADLINE.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_CLASSIFICATION_ID.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_IDENTIFIER.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_ITIL_ID.getKey(), false));
                this.add(new TicketFieldVisibility("custom1", true));
                this.add(new TicketFieldVisibility("custom2", true));
                this.add(new TicketFieldVisibility("custom3", true));
                this.add(new TicketFieldVisibility("custom4", true));
                this.add(new TicketFieldVisibility("custom5", true));
                this.add(new TicketFieldVisibility("custom6", true));
                this.add(new TicketFieldVisibility("custom7", true));
                this.add(new TicketFieldVisibility(Tickets.FIELD_TARGET_TIME.getKey(), true));
                this.add(new TicketFieldVisibility("processid", false));
                this.add(new TicketFieldVisibility("processtask", false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_AUTO_CC.getKey(), true));
                this.add(new TicketFieldVisibility("ticketrating", true));
            }
        } : new ArrayList<TicketFieldVisibility>(){
            {
                this.add(new TicketFieldVisibility(Tickets.FIELD_RESOURCE_GUID.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_PRIORITY_ID.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_CATEGORY_ID.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_DEADLINE.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_CLASSIFICATION_ID.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_IDENTIFIER.getKey(), false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_ITIL_ID.getKey(), false));
                this.add(new TicketFieldVisibility("custom1", false));
                this.add(new TicketFieldVisibility("custom2", false));
                this.add(new TicketFieldVisibility("custom3", false));
                this.add(new TicketFieldVisibility("custom4", false));
                this.add(new TicketFieldVisibility("custom5", false));
                this.add(new TicketFieldVisibility("custom6", false));
                this.add(new TicketFieldVisibility("custom7", false));
                this.add(new TicketFieldVisibility(Tickets.FIELD_TARGET_TIME.getKey(), false));
                this.add(new TicketFieldVisibility("processid", false));
                this.add(new TicketFieldVisibility("processtask", false));
                this.add(new TicketFieldVisibility("ticketrating", true));
            }
        };
    }

    public ArrayList<TicketFieldVisibility> getHiddenTicketFields() {
        return this.hiddenTicketFields;
    }

    public void setHiddenTicketFields(ArrayList<TicketFieldVisibility> hiddenTicketFields) {
        this.hiddenTicketFields = hiddenTicketFields;
    }

    public void setSuggestKbArticles(boolean suggestKbArticles) {
        this.suggestKbArticles = suggestKbArticles;
    }

    public boolean isSuggestKbArticles() {
        return this.suggestKbArticles;
    }

    public void merge(NewTicketDialogSettings p) {
        ArrayList<TicketFieldVisibility> oldHiddenField = this.hiddenTicketFields;
        this.hiddenTicketFields = p.hiddenTicketFields;
        if (oldHiddenField != null && this.hiddenTicketFields != null) {
            for (TicketFieldVisibility tfv : oldHiddenField) {
                if (this.hiddenTicketFields.contains(tfv)) continue;
                this.hiddenTicketFields.add(tfv);
            }
        }
        this.suggestKbArticles = p.suggestKbArticles;
    }
}

