/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.ColorUtils;
import com.inet.lib.less.CssMediaOutput;
import com.inet.lib.less.CssOutput;
import com.inet.lib.less.CssPlainOutput;
import com.inet.lib.less.CssRuleOutput;
import com.inet.lib.less.Expression;
import com.inet.lib.less.Formattable;
import com.inet.lib.less.LessException;
import com.inet.lib.less.LessExtend;
import com.inet.lib.less.LessExtendMap;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.LessParser;
import com.inet.lib.less.Mixin;
import com.inet.lib.less.Operation;
import com.inet.lib.less.ReaderFactory;
import com.inet.lib.less.ReferenceInfo;
import com.inet.lib.less.Rule;
import com.inet.lib.less.SelectorUtils;
import com.inet.lib.less.StringBuilderPool;
import com.inet.lib.less.UrlUtils;
import com.inet.lib.less.ValueExpression;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CssFormatter
implements Cloneable {
    private final SharedState state = new SharedState();
    private LessExtendMap lessExtends = SharedState.access$100(this.state);
    private ReaderFactory readerFactory;
    private Map<String, String> options;
    private int rewriteUrl;
    private CssOutput currentOutput;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final ArrayDeque<StringBuilder> outputs = new ArrayDeque();
    private StringBuilder output;
    private StringBuilder insets = new StringBuilder();
    private boolean inlineMode;
    private final DecimalFormat decFormat = new DecimalFormat("#.########", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private int blockDeep;
    private boolean isGuard;
    private boolean guardDefault;
    private boolean wasDefaultFunction;

    CssFormatter() {
        this.state.header = this.copy(null);
        this.currentOutput = new CssPlainOutput(((SharedState)this.state).header.output);
        this.state.results.add(this.currentOutput);
    }

    private CssFormatter copy(@Nullable StringBuilder output) {
        try {
            CssFormatter formatter = (CssFormatter)this.clone();
            formatter.output = output == null ? this.state.pool.get() : output;
            formatter.insets = this.state.pool.get();
            formatter.insets.append((CharSequence)this.insets);
            return formatter;
        }
        catch (CloneNotSupportedException ex) {
            throw new LessException(ex);
        }
    }

    void format(LessParser parser, URL baseURL, ReaderFactory readerFactory, StringBuilder target, @Nonnull Map<String, String> options) {
        this.state.baseURL = baseURL;
        this.readerFactory = readerFactory;
        this.options = options;
        this.rewriteUrl = this.parseRewriteUrl();
        this.addVariables(parser.getVariables());
        this.state.isReference = false;
        for (Formattable rule : parser.getRules()) {
            rule.prepare(this);
        }
        block6: for (Formattable rule : parser.getRules()) {
            switch (rule.getType()) {
                case 7: {
                    this.state.isReference = ((ReferenceInfo)rule).isReference();
                    continue block6;
                }
                case 2: {
                    ((Mixin)rule).appendSubRules(null, this);
                    continue block6;
                }
                case 5: {
                    if (!this.state.isReference) break;
                    continue block6;
                }
            }
            rule.appendTo(this);
        }
        this.removeVariables(parser.getVariables());
        this.output = target;
        for (CssOutput result : this.state.results) {
            result.appendTo(target, this.lessExtends, this);
        }
    }

    private int parseRewriteUrl() {
        String rewrite = this.options.get("rewrite-urls");
        if (rewrite != null) {
            switch (rewrite.toLowerCase()) {
                case "off": {
                    return 0;
                }
                case "local": {
                    return 1;
                }
                case "all": {
                    return 2;
                }
            }
        }
        return 0;
    }

    CssFormatter getHeader() {
        return this.state.header;
    }

    boolean isCharsetDirective() {
        return this.state.charsetDirective;
    }

    void setCharsetDirective() {
        this.state.charsetDirective = true;
    }

    void addOutput() {
        if (this.output != null) {
            this.outputs.addLast(this.output);
        }
        this.output = this.state.pool.get();
    }

    void freeOutput() {
        this.state.pool.free(this.output);
        this.output = this.outputs.size() > 0 ? this.outputs.removeLast() : null;
    }

    String releaseOutput() {
        if (this.output == null) {
            return "";
        }
        String str = this.output.toString();
        this.freeOutput();
        return str;
    }

    void flushOutput() {
        StringBuilder current = this.output;
        this.freeOutput();
        this.output.append((CharSequence)current);
    }

    int getOutputSize() {
        return this.output == null ? -1 : this.output.length();
    }

    void setOutputSize(int size) {
        this.output.setLength(size);
    }

    void add(LessExtend lessExtend) {
        if (this.state.isReference) {
            return;
        }
        this.lessExtends.add(lessExtend, this.currentOutput.getSelectors());
    }

    public URL getBaseURL() {
        return this.state.baseURL;
    }

    boolean isRewriteUrl(String url) {
        switch (this.rewriteUrl) {
            default: {
                return false;
            }
            case 1: {
                return url.startsWith(".");
            }
            case 2: 
        }
        if (url.startsWith("/")) {
            return false;
        }
        try {
            return new URI(url).getScheme() == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean isRewriteUrlOff() {
        return this.rewriteUrl == 0;
    }

    ReaderFactory getReaderFactory() {
        return this.readerFactory;
    }

    Expression getVariable(String name) {
        int i;
        for (i = this.state.stackIdx - 1; i >= 0; --i) {
            Expression variable = ((Scope)this.state.stack.get(i)).getVariable(name);
            if (variable == null) continue;
            return variable;
        }
        if (name.equals("@arguments")) {
            for (i = this.state.stackIdx - 1; i >= 0; --i) {
                Scope scope = (Scope)this.state.stack.get(i);
                if (scope.parameters == null) continue;
                Operation params = new Operation((LessObject)scope.mixin, ' ');
                for (Expression expr : scope.parameters.values()) {
                    if (expr.getClass() == Operation.class && scope.parameters.size() == 1) {
                        return expr;
                    }
                    params.addOperand(expr);
                }
                return params;
            }
        }
        return null;
    }

    void addMixin(Rule mixin, Map<String, Expression> parameters, Map<String, Expression> variables) {
        Scope scope;
        int idx = this.state.stackIdx++;
        if (this.state.stack.size() <= idx) {
            scope = new Scope();
            this.state.stack.add(scope);
        } else {
            scope = (Scope)this.state.stack.get(idx);
            scope.returns.clear();
        }
        scope.mixin = mixin;
        scope.parameters = parameters;
        scope.variables = variables;
    }

    void removeMixin() {
        int idx = this.state.stackIdx - 1;
        Scope current = (Scope)this.state.stack.get(idx);
        if (idx > 0) {
            Scope previous = (Scope)this.state.stack.get(idx - 1);
            Map currentReturn = previous.returns;
            Map vars = current.variables;
            if (vars != null) {
                for (Map.Entry entry : vars.entrySet()) {
                    if (previous.getVariable((String)entry.getKey()) != null) continue;
                    currentReturn.put(entry.getKey(), ValueExpression.eval(this, (Expression)entry.getValue()));
                }
            }
            if ((vars = current.returns) != null) {
                for (Map.Entry entry : vars.entrySet()) {
                    if (previous.getVariable((String)entry.getKey()) != null) continue;
                    currentReturn.put(entry.getKey(), ValueExpression.eval(this, (Expression)entry.getValue()));
                }
            }
        }
        this.state.stackIdx--;
        this.state.rulesStackModCount++;
    }

    void addVariables(HashMap<String, Expression> variables) {
        this.addMixin(null, null, variables);
    }

    void removeVariables(Map<String, Expression> variables) {
        this.removeMixin();
    }

    void addGuardParameters(Map<String, Expression> parameters, boolean isDefault) {
        this.isGuard = true;
        this.wasDefaultFunction = false;
        this.guardDefault = isDefault;
        if (parameters != null) {
            this.addMixin(null, parameters, null);
        }
    }

    void removeGuardParameters(Map<String, Expression> parameters) {
        if (parameters != null) {
            this.removeMixin();
        }
        this.isGuard = false;
    }

    boolean isGuard() {
        return this.isGuard;
    }

    boolean getGuardDefault() {
        this.wasDefaultFunction = true;
        return this.guardDefault;
    }

    boolean wasDefaultFunction() {
        return this.wasDefaultFunction;
    }

    boolean containsRule(Rule rule) {
        for (int i = this.state.stackIdx - 1; i >= 0; --i) {
            if (rule != ((Scope)this.state.stack.get(i)).mixin) continue;
            return true;
        }
        return false;
    }

    List<Rule> getMixin(String name) {
        for (int i = this.state.stackIdx - 1; i >= 0; --i) {
            List<Rule> rules;
            Rule mixin = ((Scope)this.state.stack.get(i)).mixin;
            if (mixin == null || (rules = mixin.getMixin(name)) == null) continue;
            for (int r = 0; r < rules.size(); ++r) {
                if (this.containsRule(rules.get(r))) continue;
                return rules;
            }
        }
        return null;
    }

    int stackID() {
        return this.state.rulesStackModCount;
    }

    StringBuilder getOutput() {
        if (this.output == null) {
            CssFormatter block = this.copy(null);
            this.state.results.add(new CssPlainOutput(block.output));
            this.output = block.output;
        }
        return this.output;
    }

    void setInlineMode(boolean mode) {
        this.inlineMode = mode;
    }

    boolean inlineMode() {
        return this.inlineMode;
    }

    public CssFormatter append(String str) {
        if (this.inlineMode) {
            str = UrlUtils.removeQuote(str);
        }
        this.output.append(str);
        return this;
    }

    public CssFormatter appendColor(double color, @Nullable String hint) {
        if (!this.inlineMode && hint != null) {
            this.output.append(hint);
        } else {
            int argb = ColorUtils.argb(color);
            this.output.append('#');
            this.appendHex(argb, 6);
        }
        return this;
    }

    public void appendHex(int value, int digits) {
        if (digits > 1) {
            this.appendHex(value >>> 4, digits - 1);
        }
        this.output.append(DIGITS[value & 0xF]);
    }

    public CssFormatter append(char ch) {
        this.output.append(ch);
        return this;
    }

    public CssFormatter append(double value) {
        if (value == (double)((int)value)) {
            this.output.append(Integer.toString((int)value));
        } else {
            this.output.append(this.decFormat.format(value));
        }
        return this;
    }

    public CssFormatter appendValue(double value, String unit) {
        this.append(value);
        this.append(unit);
        return this;
    }

    void incInsets() {
        this.insets.append("  ");
    }

    void decInsets() {
        this.insets.setLength(this.insets.length() - 2);
    }

    CssFormatter startBlock(String[] selectors) {
        List results = this.state.results;
        if (this.blockDeep == 0) {
            CssFormatter block;
            CssOutput cssOutput;
            this.output = null;
            CssOutput nextOutput = null;
            if (results.size() > 0 && !"@font-face".equals(selectors[0]) && Arrays.equals(selectors, (cssOutput = (CssOutput)results.get(results.size() - 1)).getSelectors())) {
                nextOutput = cssOutput;
            }
            if (nextOutput == null) {
                block = this.copy(null);
                if (selectors[0].startsWith("@media")) {
                    block.lessExtends = new LessExtendMap(this.state.lessExtends);
                    nextOutput = new CssMediaOutput(selectors, block.output, this.state.isReference, block.lessExtends);
                } else {
                    nextOutput = new CssRuleOutput(selectors, block.output, this.state.isReference);
                }
                results.add(nextOutput);
            } else {
                block = this.copy(nextOutput.getOutput());
            }
            block.currentOutput = nextOutput;
            block.incInsets();
            ++block.blockDeep;
            return block;
        }
        if (selectors[0].startsWith("@media")) {
            CssFormatter block = this.copy(null);
            block.lessExtends = new LessExtendMap(this.state.lessExtends);
            String[] sel = new String[]{this.currentOutput.getSelectors()[0] + " and " + selectors[0].substring(6).trim()};
            block.currentOutput = new CssMediaOutput(sel, block.output, this.state.isReference, block.lessExtends);
            results.add(block.currentOutput);
            block.insets.setLength(2);
            block.blockDeep = 1;
            return block;
        }
        if (this.blockDeep == 1 && this.currentOutput.getClass() == CssMediaOutput.class) {
            CssFormatter block = this.copy(null);
            block.incInsets();
            block.currentOutput = this.currentOutput;
            ((CssMediaOutput)this.currentOutput).startBlock(selectors, block.output);
            ++block.blockDeep;
            return block;
        }
        ++this.blockDeep;
        this.startBlockImpl(selectors);
        return this;
    }

    void startBlockImpl(String[] selectors) {
        for (int i = 0; i < selectors.length; ++i) {
            if (i > 0) {
                this.output.append(',');
                this.newline();
            }
            this.insets();
            this.append(selectors[i]);
        }
        this.space();
        this.output.append('{');
        this.newline();
        this.incInsets();
    }

    CssFormatter endBlock() {
        --this.blockDeep;
        if (this.blockDeep == 0) {
            this.state.pool.free(this.insets);
            this.insets = null;
            this.inlineMode = false;
        } else if (this.blockDeep == 1 && this.currentOutput.getClass() == CssMediaOutput.class) {
            this.state.pool.free(this.insets);
            this.insets = null;
            this.inlineMode = false;
        } else {
            this.endBlockImpl();
        }
        return this;
    }

    void endBlockImpl() {
        this.decInsets();
        this.insets();
        this.output.append('}');
        this.newline();
    }

    void appendProperty(@Nonnull String name, @Nonnull Expression value) {
        if (this.output == null) {
            throw new LessException("Properties must be inside selector blocks, they cannot be in the root.");
        }
        this.insets();
        name = SelectorUtils.replacePlaceHolder(this, name, value);
        this.output.append(name).append(':');
        this.space();
        value.appendTo(this);
        if (this.state.importantCount > 0 || value.isImportant()) {
            this.output.append(" !important");
        }
        this.semicolon();
        this.newline();
    }

    void incImportant() {
        this.state.importantCount++;
    }

    void decImportant() {
        this.state.importantCount--;
    }

    CssFormatter space() {
        this.output.append(' ');
        return this;
    }

    CssFormatter newline() {
        this.output.append('\n');
        return this;
    }

    void semicolon() {
        this.output.append(';');
    }

    void insets() {
        this.output.append((CharSequence)this.insets);
    }

    CssFormatter comment(String msg) {
        this.getOutput().append((CharSequence)this.insets).append(msg).append('\n');
        return this;
    }

    DecimalFormat getFormat() {
        return this.decFormat;
    }

    private static class SharedState {
        private final StringBuilderPool pool = new StringBuilderPool();
        private URL baseURL;
        private final ArrayList<Scope> stack = new ArrayList();
        private int stackIdx;
        private int rulesStackModCount;
        private final List<CssOutput> results = new ArrayList<CssOutput>();
        private boolean charsetDirective;
        private CssFormatter header;
        private boolean isReference;
        private int importantCount;
        private LessExtendMap lessExtends = new LessExtendMap();

        private SharedState() {
        }
    }

    private static class Scope {
        private Rule mixin;
        private Map<String, Expression> parameters;
        private Map<String, Expression> variables;
        private final Map<String, Expression> returns = new HashMap<String, Expression>();

        private Scope() {
        }

        Expression getVariable(String name) {
            Expression variable;
            if (this.parameters != null && (variable = this.parameters.get(name)) != null) {
                return variable;
            }
            if (this.variables != null && (variable = this.variables.get(name)) != null) {
                return variable;
            }
            if (this.returns != null && (variable = this.returns.get(name)) != null) {
                return variable;
            }
            return null;
        }
    }
}

