/*
 * Decompiled with CFR 0.152.
 */
package com.inet.theme.server;

import com.inet.annotations.InternalApi;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ServletUtils;
import com.inet.theme.server.ThemeEngine;
import com.inet.theme.server.ThemeEngineFactory;
import com.inet.theme.server.ThemeServerPlugin;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@InternalApi
public class ThemeService {
    private final ThemeEngine u;
    public static final String KEY_USERS_THEMENAME = "theme.themename";
    public static final String KEY_USERS_THEMECOLORS = "theme.themecolors";
    public static final String VALUE_USERDEFINED = "{?USERDEFINED?}";

    public ThemeService(String appKey) {
        this(appKey, true);
    }

    public ThemeService(String appKey, boolean includeBootstrap) {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        ThemeEngineFactory themeEngineFactory = (ThemeEngineFactory)serverPluginManager.getSingleInstance(ThemeEngineFactory.class);
        this.u = themeEngineFactory.getThemeEngine(appKey, includeBootstrap);
    }

    public boolean isThemeingActive(HttpServletRequest request) {
        THEMEPERMISSIONS tHEMEPERMISSIONS;
        String string = request.getParameter("themecolors");
        if (string != null && !string.isEmpty()) {
            return true;
        }
        String string2 = request.getParameter("theme");
        if (string2 != null && !string2.isEmpty() && !VALUE_USERDEFINED.equals(string2)) {
            return true;
        }
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        String string3 = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMENAME.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMENAME.getDefault());
        if (string3 != null && !string3.isEmpty() && !VALUE_USERDEFINED.equals(string3)) {
            return true;
        }
        String string4 = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMECOLORS.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMECOLORS.getDefault());
        if (string4 != null && !string4.isEmpty() && VALUE_USERDEFINED.equals(string3)) {
            return true;
        }
        String string5 = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMEPERMISSIONS.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMEPERMISSIONS.getDefault());
        if (string5 == null || string5.isEmpty()) {
            string5 = THEMEPERMISSIONS.all.name();
        }
        if ((tHEMEPERMISSIONS = THEMEPERMISSIONS.valueOf(string5)) == THEMEPERMISSIONS.none) {
            return false;
        }
        UserManager userManager = UserManager.getInstance();
        UserAccount userAccount = userManager.getCurrentUserAccount();
        return userAccount != null;
    }

    public boolean isThemeingConfigured(HttpServletRequest request) {
        Object object;
        THEMEPERMISSIONS tHEMEPERMISSIONS;
        Object object2;
        String string = request.getParameter("themecolors");
        if (string != null && !string.isEmpty()) {
            return true;
        }
        String string2 = request.getParameter("theme");
        if (string2 != null && !string2.isEmpty() && !VALUE_USERDEFINED.equals(string2)) {
            return true;
        }
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        String string3 = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMENAME.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMENAME.getDefault());
        if (string3 != null && !string3.isEmpty() && !VALUE_USERDEFINED.equals(string3) && (object2 = this.listAvailableThemes()) != null && ((ArrayList)object2).contains(string3)) {
            return true;
        }
        object2 = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMECOLORS.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMECOLORS.getDefault());
        if (object2 != null && !((String)object2).isEmpty() && VALUE_USERDEFINED.equals(string3)) {
            return true;
        }
        String string4 = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMEPERMISSIONS.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMEPERMISSIONS.getDefault());
        if (string4 == null || string4.isEmpty()) {
            string4 = THEMEPERMISSIONS.all.name();
        }
        if ((tHEMEPERMISSIONS = THEMEPERMISSIONS.valueOf(string4)) == THEMEPERMISSIONS.none) {
            return false;
        }
        UserManager userManager = UserManager.getInstance();
        UserAccount userAccount = userManager.getCurrentUserAccount();
        if (userAccount == null) {
            return false;
        }
        String string5 = (String)userAccount.getValue(userManager.getField(KEY_USERS_THEMENAME));
        if (string5 != null && !string5.isEmpty() && !VALUE_USERDEFINED.equals(string5) && (object = this.listAvailableThemes()) != null && ((ArrayList)object).contains(string5)) {
            return true;
        }
        object = (String)userAccount.getValue(userManager.getField(KEY_USERS_THEMECOLORS));
        return object != null && !((String)object).isEmpty() && VALUE_USERDEFINED.equals(string5);
    }

    public THEMESERVEDSTATE serveCorporateTheme(HttpServletRequest request, HttpServletResponse response) {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        boolean bl = false;
        String string = null;
        String string2 = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            string = request.getParameter("theme");
            string2 = request.getParameter("themecolors");
            if (string2 != null && string2.length() > 0) {
                string = VALUE_USERDEFINED;
            }
            if (string == null && string2 == null) {
                object4 = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMEPERMISSIONS.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMEPERMISSIONS.getDefault());
                if (object4 == null || ((String)object4).isEmpty()) {
                    object4 = THEMEPERMISSIONS.all.name();
                }
                if ((object3 = THEMEPERMISSIONS.valueOf((String)object4)) != THEMEPERMISSIONS.none && request.getParameter("themetimestamp") == null) {
                    object2 = UserManager.getInstance();
                    object = object2.getCurrentUserAccount();
                    if (object != null) {
                        string = (String)object.getValue(object2.getField(KEY_USERS_THEMENAME));
                        string2 = (String)object.getValue(object2.getField(KEY_USERS_THEMECOLORS));
                    }
                    if (string2 != null && !string2.isEmpty() && !VALUE_USERDEFINED.equals(string)) {
                        string2 = null;
                    }
                    if (string2 != null && object3 != THEMEPERMISSIONS.all && object3 != THEMEPERMISSIONS.colorsonly) {
                        string2 = null;
                    }
                    if (VALUE_USERDEFINED.equals(string) && (string2 == null || string2.length() == 0)) {
                        string2 = "{}";
                    }
                    if (VALUE_USERDEFINED.equals(string) && object3 == THEMEPERMISSIONS.themeonly) {
                        string = null;
                        string2 = null;
                    }
                    if (string != null && !VALUE_USERDEFINED.equals(string) && object3 != THEMEPERMISSIONS.all && object3 != THEMEPERMISSIONS.themeonly) {
                        string = null;
                        string2 = null;
                    }
                    if (string != null && !VALUE_USERDEFINED.equals(string) && !this.listAvailableThemes().contains(string)) {
                        string = null;
                        string2 = null;
                    }
                    if (string2 != null && !string2.isEmpty() || string != null && !string.isEmpty()) {
                        bl = true;
                    }
                }
                if (!bl) {
                    string = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMENAME.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMENAME.getDefault());
                    string2 = configuration.get(ThemeServerPlugin.KEY_ALLUSERS_THEMECOLORS.getKey(), ThemeServerPlugin.KEY_ALLUSERS_THEMECOLORS.getDefault());
                }
            }
            if (string2 != null && !string2.isEmpty() && !VALUE_USERDEFINED.equals(string)) {
                string2 = null;
            }
            if (VALUE_USERDEFINED.equals(string) && (string2 == null || string2.length() == 0)) {
                string2 = "{}";
            }
            if (string == null && string2 == null) {
                return THEMESERVEDSTATE.notheme;
            }
            object4 = null;
            if (string2 != null && !string2.isEmpty()) {
                object3 = (HashMap)new Json().fromJson(string2, HashMap.class);
                object4 = new TreeMap(object3);
                object2 = this.u.getDefaultColors();
                if (object2 != null) {
                    for (Map.Entry entry : ((HashMap)object2).entrySet()) {
                        if (((TreeMap)object4).containsKey(entry.getKey())) continue;
                        Object object5 = (String)entry.getValue();
                        if (((String)entry.getKey()).endsWith("size")) {
                            object5 = (String)object5 + "px";
                        }
                        ((TreeMap)object4).put((String)entry.getKey(), object5);
                    }
                }
            } else {
                string2 = null;
            }
            boolean bl2 = string != null && !string.isEmpty() && !VALUE_USERDEFINED.equals(string);
            object2 = null;
            if (bl2) {
                object2 = this.u.getCompiledTheme(string);
            } else if (string2 != null) {
                object2 = this.u.getCompiledThemeColors((Map<String, String>)object4);
            }
            if (object2 == null) {
                object = bl2 ? string : string2;
                ThemeEngine.e.warn((Object)("Current Theme (" + (String)object + ") could not be served!"));
                return this.u.isErrorOnLastCompile() ? THEMESERVEDSTATE.error : THEMESERVEDSTATE.notheme;
            }
            response.setContentType("text/css");
            ServletUtils.sendBinaryData((InputStream)object2, (OutputStream)response.getOutputStream());
        }
        catch (IOException iOException) {
            ThemeEngine.e.error((Throwable)iOException);
        }
        return this.u.isErrorOnLastCompile() ? THEMESERVEDSTATE.error : THEMESERVEDSTATE.served;
    }

    public ArrayList<String> listAvailableThemes() {
        return this.u.getAvailableThemes();
    }

    public HashMap<String, String> getDefaultColors() {
        return this.u.getDefaultColors();
    }

    @InternalApi
    public static final class THEMEPERMISSIONS
    extends Enum<THEMEPERMISSIONS> {
        public static final /* enum */ THEMEPERMISSIONS none = new THEMEPERMISSIONS();
        public static final /* enum */ THEMEPERMISSIONS themeonly = new THEMEPERMISSIONS();
        public static final /* enum */ THEMEPERMISSIONS colorsonly = new THEMEPERMISSIONS();
        public static final /* enum */ THEMEPERMISSIONS all = new THEMEPERMISSIONS();
        private static final /* synthetic */ THEMEPERMISSIONS[] v;

        public static THEMEPERMISSIONS[] values() {
            return (THEMEPERMISSIONS[])v.clone();
        }

        public static THEMEPERMISSIONS valueOf(String name) {
            return Enum.valueOf(THEMEPERMISSIONS.class, name);
        }

        private static /* synthetic */ THEMEPERMISSIONS[] f() {
            return new THEMEPERMISSIONS[]{none, themeonly, colorsonly, all};
        }

        static {
            v = THEMEPERMISSIONS.f();
        }
    }

    @InternalApi
    public static final class THEMESERVEDSTATE
    extends Enum<THEMESERVEDSTATE> {
        public static final /* enum */ THEMESERVEDSTATE notheme = new THEMESERVEDSTATE();
        public static final /* enum */ THEMESERVEDSTATE served = new THEMESERVEDSTATE();
        public static final /* enum */ THEMESERVEDSTATE notmodified = new THEMESERVEDSTATE();
        public static final /* enum */ THEMESERVEDSTATE error = new THEMESERVEDSTATE();
        private static final /* synthetic */ THEMESERVEDSTATE[] w;

        public static THEMESERVEDSTATE[] values() {
            return (THEMESERVEDSTATE[])w.clone();
        }

        public static THEMESERVEDSTATE valueOf(String name) {
            return Enum.valueOf(THEMESERVEDSTATE.class, name);
        }

        private static /* synthetic */ THEMESERVEDSTATE[] g() {
            return new THEMESERVEDSTATE[]{notheme, served, notmodified, error};
        }

        static {
            w = THEMESERVEDSTATE.g();
        }
    }
}

