/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler.guid.viewtask;

import com.inet.annotations.JsonData;
import com.inet.taskplanner.server.api.history.HistoryEntry;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.annotation.Nonnull;

@Schema(description="Container for information about a single execution of a task.")
@JsonData
public class HistoryDescription {
    @Schema(description="Start time of the task execution.")
    private long start;
    @Schema(description="End time of the task execution.")
    private long end;
    @Schema(description="List of errors encountered during execution.")
    private List<String> errors;
    @Schema(description="List of skipped result actions during execution.")
    private List<String> skippedresultactions;
    @Schema(description="Count of executed series during execution.")
    private int executedseriescount;
    @Schema(description="Progress percentage of the task execution.")
    private int progress;

    private HistoryDescription() {
    }

    public static HistoryDescription from(@Nonnull HistoryEntry entry) {
        HistoryDescription historyDescription = new HistoryDescription();
        historyDescription.start = entry.getExecutionStartTime();
        historyDescription.end = entry.getExecutionFinishTime();
        historyDescription.errors = entry.getErrors();
        historyDescription.skippedresultactions = entry.getSkippedResultActions();
        historyDescription.executedseriescount = entry.getExecutedSeriesCount();
        historyDescription.progress = entry.getProgress();
        return historyDescription;
    }
}

