/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.internal;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.history.HistoryEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonData
public class ExecutionInformationImpl
implements HistoryEntry {
    public static final long RUNNING = 0L;
    public static final long NOT_FINISHED = -1L;
    private long executionStartTime;
    private long executionFinishTime;
    private int progress = 0;
    private List<String> errors = new ArrayList<String>();
    private List<String> skippedResultActions = new ArrayList<String>();
    private int executedSeriesCount = -1;
    private GUID executionId;

    private ExecutionInformationImpl() {
    }

    public ExecutionInformationImpl(long executionStartTime, List<String> errors, List<String> skippedResultActions, long executionFinishTime, int executedSeriesCount, int progress, GUID executionId) {
        this.executionStartTime = executionStartTime;
        this.progress = progress;
        this.executionId = executionId;
        this.errors = new ArrayList<String>(errors);
        this.skippedResultActions = new ArrayList<String>(skippedResultActions);
        this.executedSeriesCount = executedSeriesCount;
        this.executionFinishTime = executionFinishTime;
    }

    @Override
    public long getExecutionStartTime() {
        return this.executionStartTime;
    }

    @Override
    public long getExecutionFinishTime() {
        return this.executionFinishTime;
    }

    public void setExecutionFinishTime(long executionFinishTime) {
        this.executionFinishTime = executionFinishTime;
    }

    @Override
    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public List<String> getSkippedResultActions() {
        return Collections.unmodifiableList(this.skippedResultActions);
    }

    @Override
    public int getExecutedSeriesCount() {
        return this.executedSeriesCount;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public String toString() {
        return "ExecutionInformationImpl [executionStartTime=" + this.executionStartTime + ", executionFinishTime=" + this.executionFinishTime + ", progress=" + this.progress + ", errors=" + String.valueOf(this.errors) + ", skippedResultActions=" + String.valueOf(this.skippedResultActions) + ", executedSeriesCount=" + this.executedSeriesCount + "]";
    }

    @Override
    public GUID getExecutionId() {
        return this.executionId;
    }
}

