/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.time;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.logging.LogID;
import com.inet.persistence.Persistence;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.thread.ServerLock;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;

@InternalApi
public abstract class AbstractTimeTrigger
implements Trigger {
    private GUID taskID;
    private Trigger.TriggerAction br;
    private DefaultTimerTask bv;
    public static final int NUM_OF_NEXT_EXECUTION_DATES = 3;

    @Override
    public void activate(GUID taskID, Trigger.TriggerAction action) {
        this.taskID = taskID;
        this.br = action;
        this.schedule(null);
    }

    protected synchronized void schedule(ZonedDateTime lastExecutiontime) {
        if (this.br == null) {
            return;
        }
        try {
            Optional<ZonedDateTime> optional = this.calculateNextExecutionTime(lastExecutiontime);
            if (!optional.isPresent()) {
                TaskPlannerServerPlugin.LOGGER.debug((Object)String.format("[Cron] trigger '%s' is expired.", this.getTriggerDescribingStringForLog()));
                return;
            }
            final ZonedDateTime zonedDateTime = optional.get();
            Date date = new Date(zonedDateTime.toInstant().toEpochMilli());
            if (this.bv != null) {
                this.bv.cancel();
            }
            this.bv = new DefaultTimerTask(){

                public void runImpl() {
                    LogID.reset();
                    if (TaskPlannerServerPlugin.LOGGER.isDebug()) {
                        TaskPlannerServerPlugin.LOGGER.debug((Object)String.format("[Cron] trigger task for expression '%s'", AbstractTimeTrigger.this.getTriggerDescribingStringForLog()));
                    }
                    AbstractTimeTrigger.this.triggerAction();
                    AbstractTimeTrigger.this.schedule(zonedDateTime);
                }
            };
            DefaultTimer.getInstance().schedule(this.bv, date);
        }
        catch (RuntimeException runtimeException) {
            TaskPlannerServerPlugin.LOGGER.error((Object)String.format("[Cron] Trigger for expression '%s' cannot be activated", this.getTriggerDescribingStringForLog()));
            TaskPlannerServerPlugin.LOGGER.error((Throwable)runtimeException);
        }
    }

    protected void triggerAction() {
        Persistence persistence = Persistence.getInstance();
        while (true) {
            ServerLock serverLock = persistence.tryLock(this.taskID);
            try {
                if (this.br == null) {
                    return;
                }
                if (serverLock == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        TaskPlannerServerPlugin.LOGGER.error((Throwable)interruptedException);
                    }
                    continue;
                }
                this.runAction(this.br);
            }
            finally {
                if (serverLock == null) continue;
                serverLock.close();
                continue;
            }
            break;
        }
    }

    protected void runAction(Trigger.TriggerAction action) {
        action.run();
    }

    @Override
    public synchronized void deactivate() {
        this.br = null;
        if (this.bv != null) {
            this.bv.cancel();
            this.bv = null;
            if (TaskPlannerServerPlugin.LOGGER.isDebug()) {
                TaskPlannerServerPlugin.LOGGER.debug((Object)String.format("[Cron] Trigger for '%s' canceled", this.getTriggerDescribingStringForLog()));
            }
        }
    }

    protected abstract Optional<ZonedDateTime> calculateNextExecutionTime(ZonedDateTime var1);

    protected abstract String getTriggerDescribingStringForLog();
}

