/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.parser.CronParser;
import com.inet.annotations.PublicApi;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.taskplanner.server.api.trigger.cron.a;
import com.inet.taskplanner.server.api.trigger.time.TimeTriggerFactory;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Predicate;
import javax.annotation.Nullable;

@PublicApi
public class CronTriggerFactory
extends TriggerFactory<a> {
    public static final String EXTENSION_NAME = "trigger.cron";
    public static final String PROP_CRON_EXPRESSION = "trigger.cron.expression";

    public CronTriggerFactory() {
        super(EXTENSION_NAME);
    }

    @Override
    public TriggerInfo getInformation(GUID taskID) {
        String string = TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.name", new Object[0]);
        String string2 = TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.description", new Object[0]);
        URL uRL = this.getClass().getResource("/com/inet/taskplanner/server/api/trigger/cron/cron.png");
        String string3 = "taskplanner.trigger.cron";
        TriggerInfo triggerInfo = new TriggerInfo(this.getExtensionName(), string, string2, uRL, string3, this.s());
        return triggerInfo;
    }

    private List<Field> s() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        TimeTriggerFactory.addTimeZoneDifferenceHintIfRequired(arrayList);
        TextField textField = new TextField(PROP_CRON_EXPRESSION, TaskPlannerServerPlugin.MSG.getMsg(PROP_CRON_EXPRESSION, new Object[0]));
        ZonedDateTime zonedDateTime = ZonedDateTime.now().plusHours(1L);
        textField.setValue(zonedDateTime.getMinute() + " " + zonedDateTime.getHour() + " " + zonedDateTime.getDayOfMonth() + " * ? *");
        textField.setUpdateValuesOnChange(true);
        arrayList.add(textField);
        TriggerDefinition triggerDefinition = new TriggerDefinition(this.getExtensionName());
        triggerDefinition.setProperty(textField.getKey(), textField.getValue());
        arrayList.add(new LabelField("label.syntax", TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.syntax", new Object[0]), TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.syntax.description", new Object[0])));
        arrayList.add(new LabelField("label.nextexecutions", TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.summary.nextExecutionsLabel", new Object[0]), CronTriggerFactory.getNextExecutionsSummaryText(this.getNextExecutionTimes(triggerDefinition))));
        return arrayList;
    }

    @Override
    public Map<String, String> updateValues(TriggerDefinition definition, GUID taskID) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = CronTriggerFactory.getNextExecutionsSummaryText(this.getNextExecutionTimes(definition));
        hashMap.put("label.nextexecutions", string);
        return hashMap;
    }

    public static String getNextExecutionsSummaryText(List<ZonedDateTime> nextExecutionDates) {
        StringBuilder stringBuilder = new StringBuilder();
        List<SummaryEntry> list = null;
        try {
            list = CronTriggerFactory.getNextExecutionsAsSummary(nextExecutionDates);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (list != null) {
            for (SummaryEntry summaryEntry : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(summaryEntry.getValue());
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.unknown", new Object[0]));
        }
        return stringBuilder.toString();
    }

    @Override
    public void validate(TriggerDefinition definition, GUID taskID) throws ValidationException {
        String string = definition.getProperty(PROP_CRON_EXPRESSION);
        if (string == null || string.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.error.noExpression", new Object[0])});
        }
        String string2 = CronTriggerFactory.a(string, false);
        if (string2 != null) {
            throw new ValidationException(new String[]{string2});
        }
    }

    public static String validateCronExpression(@Nullable String cronExpression) {
        return CronTriggerFactory.a(cronExpression, true);
    }

    private static String a(@Nullable String string, boolean bl) {
        try {
            CronParser cronParser = new CronParser(a.aV);
            Cron cron = cronParser.parse(string);
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
            Optional optional = executionTime.nextExecution(ZonedDateTime.now());
            for (int i2 = 0; i2 < 10 && optional.isPresent(); ++i2) {
                optional = executionTime.nextExecution((ZonedDateTime)optional.get());
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            if (runtimeException.getCause() instanceof NoSuchValueException) {
                TaskPlannerServerPlugin.LOGGER.warn((Object)runtimeException);
            }
            if (runtimeException.getMessage().contains("Values must not be empty")) {
                if (bl) {
                    TaskPlannerServerPlugin.LOGGER.warn((Object)runtimeException);
                }
                return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.implementationBug", new Object[]{string, ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getDefaultSupportAddress()});
            }
            if (bl) {
                TaskPlannerServerPlugin.LOGGER.info((Object)runtimeException);
            }
            return TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.error.expressionInvalid", new Object[]{runtimeException.getMessage()});
        }
        return null;
    }

    @Override
    protected a createInstanceFrom(TriggerDefinition definition, GUID taskID) {
        return new a(definition.getProperty(PROP_CRON_EXPRESSION));
    }

    @Override
    public SummaryInfo getSummary(TriggerDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        String string = definition.getProperty(PROP_CRON_EXPRESSION);
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg(PROP_CRON_EXPRESSION, new Object[0]), string));
        arrayList.addAll(CronTriggerFactory.getNextExecutionsAsSummary(this.getNextExecutionTimes(definition)));
        return new SummaryInfo(arrayList);
    }

    @Override
    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        String string = definition.getProperty(PROP_CRON_EXPRESSION);
        return CronTriggerFactory.getNextExecutionsForCronExpression(string);
    }

    public static List<SummaryEntry> getNextExecutionsAsSummary(List<ZonedDateTime> nextExecutions) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        if (!nextExecutions.isEmpty()) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT).withLocale(ClientLocale.getThreadLocale());
            for (ZonedDateTime zonedDateTime : nextExecutions) {
                Object object = zonedDateTime.format(dateTimeFormatter);
                if (!Objects.equals(ClientTimezone.getTimeZone(), TimeZone.getDefault())) {
                    object = (String)object + "\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0" + TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.summary.nextExecutionsLabel.suffixLocalTime", new Object[]{zonedDateTime.format(dateTimeFormatter.withZone(ClientTimezone.getTimeZone().toZoneId()))});
                }
                if (arrayList.isEmpty()) {
                    arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.summary.nextExecutionsLabel", new Object[0]), (String)object));
                    continue;
                }
                arrayList.add(new SummaryEntry(null, (String)object));
            }
        }
        return arrayList;
    }

    public static List<ZonedDateTime> getNextExecutionsForCronExpression(String cronExpression) {
        return CronTriggerFactory.getNextExecutionsForCronExpression(cronExpression, ZonedDateTime.now(), null);
    }

    public static List<ZonedDateTime> getNextExecutionsForCronExpression(String cronExpression, ZonedDateTime startDate, @Nullable Predicate<ZonedDateTime> acceptDate) {
        ArrayList<ZonedDateTime> arrayList = new ArrayList<ZonedDateTime>(3);
        try {
            CronParser cronParser = new CronParser(a.aV);
            Cron cron = cronParser.parse(cronExpression);
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
            Optional optional = Optional.of(startDate);
            while (arrayList.size() < 3) {
                if (!(optional = executionTime.nextExecution(optional.get())).isPresent()) {
                    if (arrayList.size() != 1 || cronExpression.trim().split(" ").length != 6) {
                        TaskPlannerServerPlugin.LOGGER.debug((Object)("cron expression has no future executions: " + cronExpression));
                    }
                    break;
                }
                if (acceptDate != null && !acceptDate.test((ZonedDateTime)optional.get())) continue;
                arrayList.add((ZonedDateTime)optional.get());
            }
        }
        catch (Exception exception) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)("cron expression: " + cronExpression));
            TaskPlannerServerPlugin.LOGGER.debug((Object)exception);
        }
        return arrayList;
    }
}

