/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.series.db;

import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.lib.util.SqlFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.PasswordField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextAreaField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.field.VisibleCondition;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.SeriesInfo;
import com.inet.taskplanner.server.api.series.db.DataSourceProvider;
import com.inet.taskplanner.server.api.series.db.a;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@PublicApi
public class DbSeriesFactory
extends SeriesFactory<a> {
    public static final String EXTENSION = "series.db";
    public static final String DATASOURCE = "datasource";
    public static final String JDBC_URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SQL = "sql";

    public DbSeriesFactory() {
        super(EXTENSION);
    }

    @Override
    public SeriesInfo getInformation(GUID taskID) {
        Object object;
        URL uRL = this.getClass().getResource("db.png");
        ArrayList<Field> arrayList = new ArrayList<Field>();
        List<FieldCondition> list = null;
        DataSourceProvider dataSourceProvider = a.aK;
        if (dataSourceProvider != null && (object = dataSourceProvider.getDataSourceNames()).size() > 0) {
            Collections.sort(object);
            ArrayList<LocalizedKey> arrayList2 = new ArrayList<LocalizedKey>();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                String string = object2.next();
                arrayList2.add(new LocalizedKey(string, string));
            }
            arrayList2.add(new LocalizedKey("", TaskPlannerServerPlugin.MSG.getMsg("series.db.custom_jdbc", new Object[0])));
            object2 = new SelectField(DATASOURCE, TaskPlannerServerPlugin.MSG.getMsg("series.db.datasource", new Object[0]), arrayList2);
            ((Field)object2).setValue(arrayList2.get(0).getKey());
            arrayList.add((Field)object2);
            list = Arrays.asList(new VisibleCondition((Field)object2, FieldCondition.OP.equals, ""));
        }
        arrayList.add(new TextField(JDBC_URL, TaskPlannerServerPlugin.MSG.getMsg("series.db.jdbcurl", new Object[0])));
        arrayList.add(new TextField(USERNAME, TaskPlannerServerPlugin.MSG.getMsg("series.db.username", new Object[0])));
        arrayList.add(new PasswordField(PASSWORD, TaskPlannerServerPlugin.MSG.getMsg("series.db.password", new Object[0])));
        arrayList.add(new TextAreaField(SQL, TaskPlannerServerPlugin.MSG.getMsg("series.db.sql", new Object[0])));
        if (list != null) {
            for (int i2 = 1; i2 < 4; ++i2) {
                ((Field)arrayList.get(i2)).setConditions(list);
            }
        }
        object = new SeriesInfo(this.getExtensionName(), TaskPlannerServerPlugin.MSG.getMsg("series.db.displayname", new Object[0]), TaskPlannerServerPlugin.MSG.getMsg("series.db.description", new Object[0]), uRL, "taskplanner.series.database", arrayList);
        return object;
    }

    @Override
    public void validate(SeriesDefinition definition, GUID taskID) throws ValidationException {
        try {
            String string = definition.getProperty(SQL);
            if (string != null && SqlFunctions.isRedFlagSQL((String)string)) {
                throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("series.db.sqlNotPermitted", new Object[0])});
            }
            a a2 = this.createInstanceFrom(definition, taskID);
            a2.iterator().hasNext();
            a2.cleanUp(true);
        }
        catch (Throwable throwable) {
            throw new ValidationException(new String[]{StringFunctions.encodeHTML((String)StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable))});
        }
    }

    @Override
    protected a createInstanceFrom(SeriesDefinition definition, GUID taskID) {
        return new a(definition.getProperty(DATASOURCE), definition.getProperty(JDBC_URL), definition.getProperty(USERNAME), definition.getProperty(PASSWORD), definition.getProperty(SQL));
    }

    @Override
    public SummaryInfo getSummary(SeriesDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        String string = definition.getProperty(DATASOURCE);
        SummaryEntry summaryEntry = StringFunctions.isEmpty((String)string) ? new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("series.db.jdbcurl", new Object[0]), definition.getProperty(JDBC_URL)) : new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("series.db.datasource", new Object[0]), string);
        arrayList.add(summaryEntry);
        return new SummaryInfo(arrayList);
    }
}

