/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.field;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldType;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.List;
import java.util.Map;

@JsonData
@PublicApi
public class SelectInputField
extends Field {
    private String display;
    private int typeId;
    private boolean customValues = false;

    public SelectInputField(String key, String label, int typeID) {
        super(FieldType.SELECT_INPUT, key, label);
        this.typeId = typeID;
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
    }

    public void setDisplay(String value) {
        this.display = value;
    }

    public void setAllowCustomValues(boolean customValues) {
        this.customValues = customValues;
    }

    @Override
    public String patchSeriesPlaceholderInValue(String value, Map<String, String> seriesProperties) {
        if (!this.customValues) {
            return super.patchSeriesPlaceholderInValue(value, seriesProperties);
        }
        return this.replaceSeriesPlaceholders(value, seriesProperties);
    }

    @Override
    public String patchResultPlaceholderInValue(String value, List<JobResultContainer> results) {
        if (!this.customValues) {
            return super.patchResultPlaceholderInValue(value, results);
        }
        if (value == null) {
            return value;
        }
        return new PlaceholderResolver(value).addMetaData(results).resolve();
    }
}

