/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.internalapi;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.internal.InternalTask;
import com.inet.usersandgroups.api.user.UserManager;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class TaskShortDescription {
    private String id;
    private String name;
    private String description;
    private String owner;
    private GUID ownerId;

    private TaskShortDescription() {
    }

    public TaskShortDescription(String id, String name, String description, String owner, GUID ownerId) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.owner = owner;
        this.ownerId = ownerId;
    }

    public static TaskShortDescription from(@Nonnull InternalTask task) {
        TaskDefinition taskDefinition = task.getModel();
        String string = UserManager.getInstance().getUserAccount(task.getOwnerId()).getDisplayName();
        return new TaskShortDescription(task.getTaskID().toString(), taskDefinition.getName(), task.getModel().getDescription(), string, task.getOwnerId());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public GUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String toString() {
        return "TaskShortDescription [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", owner=" + String.valueOf(this.ownerId) + "]";
    }
}

